/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.backend.server;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.globals.backend.server.util.GlobalsPersistence;
import org.drools.workbench.screens.globals.model.GlobalsEditorContent;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.metadata.MetadataBuilder;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.builder.events.InvalidateDMOPackageCacheEvent;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class GlobalsEditorServiceImpl
extends KieService<GlobalsEditorContent>
implements GlobalsEditorService {
    @Inject
    protected CommentedOptionFactory commentedOptionFactory;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<InvalidateDMOPackageCacheEvent> invalidatePackageDMOEvent;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private GenericValidator genericValidator;
    @Inject
    private SaveAndRenameServiceImpl<GlobalsModel, Metadata> saveAndRenameService;
    private SafeSessionInfo safeSessionInfo;

    public GlobalsEditorServiceImpl() {
    }

    @Inject
    public GlobalsEditorServiceImpl(SessionInfo sessionInfo) {
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, GlobalsModel content, String comment) {
        return this.createInternal(context, fileName, content, comment, false);
    }

    public org.uberfire.backend.vfs.Path generate(org.uberfire.backend.vfs.Path context, String fileName, GlobalsModel content, String comment) {
        return this.createInternal(context, fileName, content, comment, true);
    }

    private org.uberfire.backend.vfs.Path createInternal(org.uberfire.backend.vfs.Path context, String fileName, GlobalsModel content, String comment, boolean generate) {
        try {
            Package pkg = this.moduleService.resolvePackage(context);
            String packageName = pkg == null ? null : pkg.getPackageName();
            content.setPackageName(packageName);
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            if (generate) {
                Metadata metadata = MetadataBuilder.newMetadata().withGenerated(true).build();
                this.ioService.write(nioPath, GlobalsPersistence.getInstance().marshal(content), this.metadataService.configAttrs(new HashMap(), metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            } else {
                this.ioService.write(nioPath, GlobalsPersistence.getInstance().marshal(content), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            }
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GlobalsModel load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return GlobalsPersistence.getInstance().unmarshal(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GlobalsEditorContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (GlobalsEditorContent)super.loadContent(path);
    }

    protected GlobalsEditorContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        GlobalsModel model = this.load(path);
        ModuleDataModelOracle oracle = this.dataModelService.getModuleDataModel(path);
        String[] fullyQualifiedClassNames = new String[oracle.getModuleModelFields().size()];
        oracle.getModuleModelFields().keySet().toArray(fullyQualifiedClassNames);
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, (SessionInfo)this.safeSessionInfo));
        return new GlobalsEditorContent(model, overview, Arrays.asList(fullyQualifiedClassNames));
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, GlobalsModel content, Metadata metadata, String comment) {
        try {
            Package pkg = this.moduleService.resolvePackage(resource);
            String packageName = pkg == null ? null : pkg.getPackageName();
            content.setPackageName(packageName);
            Metadata currentMetadata = this.metadataService.getMetadata(resource);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), GlobalsPersistence.getInstance().marshal(content), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            this.invalidatePackageDMOEvent.fire((Object)new InvalidateDMOPackageCacheEvent(resource));
            this.fireMetadataSocialEvents(resource, currentMetadata, metadata);
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        try {
            return this.copyService.copy(path, newName, targetDirectory, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String toSource(org.uberfire.backend.vfs.Path path, GlobalsModel model) {
        return this.sourceServices.getServiceFor(Paths.convert((org.uberfire.backend.vfs.Path)path)).getSource(Paths.convert((org.uberfire.backend.vfs.Path)path), (Object)GlobalsPersistence.getInstance().marshal(model));
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, GlobalsModel content) {
        try {
            return this.genericValidator.validate(path, GlobalsPersistence.getInstance().marshal(content));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path saveAndRename(org.uberfire.backend.vfs.Path path, String newFileName, Metadata metadata, GlobalsModel content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }
}

