/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import java.util.Arrays;
import java.util.List;
import org.drools.workbench.screens.globals.client.editor.AddGlobalPopup;
import org.drools.workbench.screens.globals.client.editor.AddGlobalPopupView;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AddGlobalPopupTest {
    @Mock
    private AddGlobalPopupView view;
    @InjectMocks
    private AddGlobalPopup addGlobalPopup;

    @Test
    public void init() {
        this.addGlobalPopup.init();
        ((AddGlobalPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.addGlobalPopup);
    }

    @Test
    public void getAlias() {
        Mockito.when((Object)this.view.getInsertedAlias()).thenReturn((Object)"alias");
        String aliasResult = this.addGlobalPopup.getAlias();
        Assert.assertEquals((Object)"alias", (Object)aliasResult);
    }

    @Test
    public void getClassName() {
        Mockito.when((Object)this.view.getSelectedClassName()).thenReturn((Object)"className");
        String classNameResult = this.addGlobalPopup.getClassName();
        Assert.assertEquals((Object)"className", (Object)classNameResult);
    }

    @Test
    public void show() {
        List<String> classNames = Arrays.asList("fqn1");
        this.addGlobalPopup.show(() -> {}, () -> {}, classNames);
        ((AddGlobalPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((AddGlobalPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setClassNames(classNames);
        ((AddGlobalPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void validateAliasWithFailures() {
        Mockito.when((Object)this.view.getInsertedAlias()).thenReturn((Object)"");
        this.addGlobalPopup.onAliasInputChanged();
        ((AddGlobalPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showAliasValidationError();
    }

    @Test
    public void validateAliasWithNoFailures() {
        Mockito.when((Object)this.view.getInsertedAlias()).thenReturn((Object)"alias");
        this.addGlobalPopup.onAliasInputChanged();
        ((AddGlobalPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideAliasValidationError();
    }

    @Test
    public void validateClassNameWithFailures() {
        Mockito.when((Object)this.view.getSelectedClassName()).thenReturn((Object)"");
        this.addGlobalPopup.onClassNameSelectChanged();
        ((AddGlobalPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showClassNameValidationError();
    }

    @Test
    public void validateClassNameWithNoFailures() {
        Mockito.when((Object)this.view.getSelectedClassName()).thenReturn((Object)"className");
        this.addGlobalPopup.onClassNameSelectChanged();
        ((AddGlobalPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideClassNameValidationError();
    }
}

