/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.rest;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.services.rest.DefaultGuvnorApprover;
import org.kie.workbench.common.services.rest.ProjectResourceDispatcher;
import org.kie.workbench.common.services.shared.rest.AddRepositoryToOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.CompileProjectRequest;
import org.kie.workbench.common.services.shared.rest.CreateOrCloneRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.CreateOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.CreateProjectRequest;
import org.kie.workbench.common.services.shared.rest.DeployProjectRequest;
import org.kie.workbench.common.services.shared.rest.InstallProjectRequest;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.JobResult;
import org.kie.workbench.common.services.shared.rest.RemoveRepositoryFromOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.RemoveRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.TestProjectRequest;

@ApplicationScoped
public class KieSessionAsyncJobRequestObserver {
    @Inject
    protected ProjectResourceDispatcher projectResourceDispatcher;
    @Inject
    protected DefaultGuvnorApprover defaultGuvnorApprover;
    @Inject
    private Event<JobResult> jobResultEvent;

    public void onCreateOrCloneRepositoryRequest(@Observes CreateOrCloneRepositoryRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.createOrCloneRepository(jobRequest.getJobId(), jobRequest.getRepository());
    }

    public void onRemoveRepositoryRequest(@Observes RemoveRepositoryRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.removeRepository(jobRequest.getJobId(), jobRequest.getRepositoryName());
    }

    public void onCreateProjectRequest(@Observes CreateProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.createProject(jobRequest.getJobId(), jobRequest.getRepositoryName(), jobRequest.getProjectName());
    }

    public void onCompileProjectRequest(@Observes CompileProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.compileProject(jobRequest.getJobId(), jobRequest.getRepositoryName(), jobRequest.getProjectName());
    }

    public void onInstallProjectRequest(@Observes InstallProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.installProject(jobRequest.getJobId(), jobRequest.getRepositoryName(), jobRequest.getProjectName());
    }

    public void onTestProjectRequest(@Observes TestProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.testProject(jobRequest.getJobId(), jobRequest.getRepositoryName(), jobRequest.getProjectName(), jobRequest.getBuildConfig());
    }

    public void onDeployProjectRequest(@Observes DeployProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.installProject(jobRequest.getJobId(), jobRequest.getRepositoryName(), jobRequest.getProjectName());
    }

    public void onCreateOrganizationalUnitRequest(@Observes CreateOrganizationalUnitRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.createOrganizationalUnit(jobRequest.getJobId(), jobRequest.getOrganizationalUnitName(), jobRequest.getOwner(), jobRequest.getRepositories());
    }

    public void onAddRepositoryToOrganizationalUnitRequest(@Observes AddRepositoryToOrganizationalUnitRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.addRepositoryToOrganizationalUnit(jobRequest.getJobId(), jobRequest.getOrganizationalUnitName(), jobRequest.getRepositoryName());
    }

    public void onAddRepositoryToOrganizationalUnitRequest(@Observes RemoveRepositoryFromOrganizationalUnitRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.removeRepositoryFromOrganizationalUnit(jobRequest.getJobId(), jobRequest.getOrganizationalUnitName(), jobRequest.getRepositoryName());
    }

    public boolean approveRequest(JobRequest jobRequest) {
        if (!this.defaultGuvnorApprover.requestApproval(jobRequest)) {
            JobResult result = new JobResult();
            result.setJobId(jobRequest.getJobId());
            result.setStatus(JobRequest.Status.DENIED);
            result.setResult("The request is denied.");
            this.jobResultEvent.fire((Object)result);
            return false;
        }
        return true;
    }
}

