/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.testscenario.client.EditableCollectionBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.callbacks.Callback;

@RunWith(value=GwtMockitoTestRunner.class)
public class EditableCollectionBoxTest {
    @Mock
    private Callback<String> changed;
    @Mock
    private TextBox view;

    @Test
    public void testOnValueChange() {
        EditableCollectionBox collectionBox = new EditableCollectionBox(this.changed, this.view, "", "");
        collectionBox.onValueChange("[1, 2, 3]");
        ((Callback)Mockito.verify(this.changed)).callback((Object)"=[1, 2, 3]");
    }

    @Test
    public void withCollectionPrefix() {
        String expected = "=[12, 34]";
        String actual = EditableCollectionBox.withCollectionPrefix((String)"[12, 34]");
        Assert.assertEquals((Object)"=[12, 34]", (Object)actual);
    }

    @Test
    public void withCollectionPrefixWhenValueAlreadyHasThePrefix() {
        String expected = "=[12, 34]";
        String actual = EditableCollectionBox.withCollectionPrefix((String)"=[12, 34]");
        Assert.assertEquals((Object)"=[12, 34]", (Object)actual);
    }

    @Test
    public void withoutCollectionPrefix() {
        String expected = "[12, 34]";
        String actual = EditableCollectionBox.withoutCollectionPrefix((String)"=[12, 34]");
        Assert.assertEquals((Object)"[12, 34]", (Object)actual);
    }

    @Test
    public void withoutCollectionPrefixWhenValueDoesNotHaveThePrefix() {
        String expected = "[12, 34]";
        String actual = EditableCollectionBox.withoutCollectionPrefix((String)"[12, 34]");
        Assert.assertEquals((Object)"[12, 34]", (Object)actual);
    }
}

