/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.client;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Date;
import java.util.HashMap;
import org.drools.workbench.screens.testscenario.client.FieldDatePicker;
import org.drools.workbench.screens.testscenario.client.FieldDatePickerView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class FieldDatePickerTest {
    @GwtMock
    DateTimeFormat dateTimeFormat;
    private FieldDatePickerView view;
    private FieldDatePicker presenter;
    private String selectedTime;
    private Date date = new Date(1L);
    private Date otherDate = new Date(2L);

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
        this.view = (FieldDatePickerView)Mockito.mock(FieldDatePickerView.class);
        this.presenter = new FieldDatePicker(this.view){

            protected DateTimeFormat getFormat() {
                return FieldDatePickerTest.this.dateTimeFormat;
            }
        };
        Mockito.when((Object)this.dateTimeFormat.parse("")).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Mockito.when((Object)this.dateTimeFormat.format(this.date)).thenReturn((Object)"some date");
        Mockito.when((Object)this.dateTimeFormat.format(this.otherDate)).thenReturn((Object)"some other date");
        this.presenter.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                FieldDatePickerTest.this.selectedTime = (String)event.getValue();
            }
        });
    }

    @Test
    public void testPresenterSet() throws Exception {
        ((FieldDatePickerView)Mockito.verify((Object)this.view)).setPresenter(this.presenter);
    }

    @Test
    public void testSetEmptyStringAsValue() throws Exception {
        this.presenter.setValue("");
    }

    @Test
    public void testSelectDate() throws Exception {
        this.presenter.onDateSelected(this.date);
        Assert.assertEquals((Object)"some date", (Object)this.selectedTime);
        this.presenter.onDateSelected(this.otherDate);
        Assert.assertEquals((Object)"some other date", (Object)this.selectedTime);
    }
}

