/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.client;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.drools.workbench.models.testscenarios.shared.ExecutionTrace;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.client.FixtureLayout;
import org.drools.workbench.screens.testscenario.client.ScenarioParentWidget;
import org.drools.workbench.screens.testscenario.client.delete.DeleteExecutionTraceButton;
import org.gwtbootstrap3.client.ui.base.button.AbstractToggleButton;
import org.gwtbootstrap3.client.ui.base.mixin.IconTextMixin;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@WithClassesToStub(value={AbstractToggleButton.class, IconTextMixin.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class FixtureLayoutTest {
    @Mock
    private DeleteExecutionTraceButton deleteExecutionTraceButton;
    private FixtureLayout testedLayout;

    @Before
    public void setUp() throws Exception {
        this.testedLayout = (FixtureLayout)Mockito.spy((Object)new FixtureLayout());
        GwtMockito.useProviderForType(DeleteExecutionTraceButton.class, aClass -> this.deleteExecutionTraceButton);
    }

    @Test
    public void testDeleteExecutionTraceButtonNoExecutionTraceRenderedAlready() throws Exception {
        Scenario scenario = (Scenario)Mockito.mock(Scenario.class);
        ExecutionTrace executionTrace = null;
        ScenarioParentWidget parentWidgetToRender = (ScenarioParentWidget)Mockito.mock(ScenarioParentWidget.class);
        this.testedLayout.addDeleteExecutionTraceButtonIfNotNull(scenario, executionTrace, parentWidgetToRender);
        ((FixtureLayout)Mockito.verify((Object)this.testedLayout, (VerificationMode)Mockito.never())).setWidget(Matchers.anyInt(), Matchers.anyInt(), (Widget)Matchers.any(DeleteExecutionTraceButton.class));
    }

    @Test
    public void testDeleteExecutionTraceButtonSomeExecutionTraceRenderedAlready() throws Exception {
        Scenario scenario = (Scenario)Mockito.mock(Scenario.class);
        ExecutionTrace executionTrace = (ExecutionTrace)Mockito.mock(ExecutionTrace.class);
        ScenarioParentWidget parentWidgetToRender = (ScenarioParentWidget)Mockito.mock(ScenarioParentWidget.class);
        this.testedLayout.addDeleteExecutionTraceButtonIfNotNull(scenario, executionTrace, parentWidgetToRender);
        ((FixtureLayout)Mockito.verify((Object)this.testedLayout)).setWidget(Matchers.eq((int)0), Matchers.eq((int)0), (Widget)Matchers.eq((Object)this.deleteExecutionTraceButton));
        ((DeleteExecutionTraceButton)Mockito.verify((Object)this.deleteExecutionTraceButton)).init(scenario, executionTrace, parentWidgetToRender);
    }
}

