/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.client;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.client.RuleSelectionEvent;
import org.drools.workbench.screens.testscenario.client.ScenarioParentWidget;
import org.drools.workbench.screens.testscenario.client.ScenarioWidgetComponentCreator;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.rulename.RuleNamesService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Select.class, Option.class})
public class ScenarioWidgetComponentCreatorTest {
    @Mock
    private RuleNamesService ruleNamesService;
    private CallerMock<RuleNamesService> ruleNamesServiceCaller;
    @Mock
    private ScenarioParentWidget scenarioWidget;
    @Mock
    private Path path;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private Scenario scenario;
    @Mock
    private HorizontalPanel horizontalPanel;
    @Mock
    private Button button;
    @Mock
    private RuleSelectionEvent ruleSelectionEvent;
    @Captor
    private ArgumentCaptor<ClickHandler> clickCaptor;
    @GwtMock
    private Select ruleNameSelector;
    private List<String> ruleNames = new ArrayList<String>();
    private ScenarioWidgetComponentCreator creator;

    @Before
    public void setup() {
        this.ruleNamesServiceCaller = new CallerMock((Object)this.ruleNamesService);
        this.creator = (ScenarioWidgetComponentCreator)Mockito.spy((Object)new ScenarioWidgetComponentCreator(this.ruleNamesServiceCaller));
        Mockito.when((Object)this.ruleNamesService.getRuleNames((Path)Matchers.any(), (String)Matchers.any())).thenReturn(this.ruleNames);
        ((ScenarioWidgetComponentCreator)Mockito.doReturn((Object)this.button).when((Object)this.creator)).newOkButton();
        ((ScenarioWidgetComponentCreator)Mockito.doNothing().when((Object)this.creator)).showSelectRuleNameWarning();
        GwtMockito.useProviderForType(HorizontalPanel.class, fakeProvider -> this.horizontalPanel);
    }

    @Test
    public void checkRuleNameSelectorWithRules() {
        this.ruleNames.add("rule1");
        this.ruleNames.add("rule2");
        this.creator.reset(this.scenarioWidget, this.path, this.oracle, this.scenario);
        ((Select)Mockito.verify((Object)this.ruleNameSelector, (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)true));
        ((ScenarioWidgetComponentCreator)Mockito.verify((Object)this.creator, (VerificationMode)Mockito.times((int)1))).makeRuleNameOption((String)Mockito.eq((Object)"rule1"));
        ((ScenarioWidgetComponentCreator)Mockito.verify((Object)this.creator, (VerificationMode)Mockito.times((int)1))).makeRuleNameOption((String)Mockito.eq((Object)"rule2"));
    }

    @Test
    public void checkRuleNameSelectorWithNoRules() {
        this.creator.reset(this.scenarioWidget, this.path, this.oracle, this.scenario);
        ((Select)Mockito.verify((Object)this.ruleNameSelector, (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)false));
        ((ScenarioWidgetComponentCreator)Mockito.verify((Object)this.creator, (VerificationMode)Mockito.never())).makeRuleNameOption(Matchers.anyString());
    }

    @Test
    public void testGetRuleSelectionWidget() throws Exception {
        this.creator.getRuleSelectionWidget(this.ruleSelectionEvent);
        ((ScenarioWidgetComponentCreator)Mockito.verify((Object)this.creator)).createOkButton(this.ruleSelectionEvent);
        ((HorizontalPanel)Mockito.verify((Object)this.horizontalPanel)).add((Widget)this.ruleNameSelector);
        ((HorizontalPanel)Mockito.verify((Object)this.horizontalPanel)).add((Widget)this.button);
    }

    @Test
    public void testOkButtonHandler() throws Exception {
        this.testOkButtonHandler("org.rule.Rule1");
    }

    @Test
    public void testOkButtonHandlerWhiteSpaceInRuleName() throws Exception {
        this.testOkButtonHandler(" org.rule.Rule1 ");
    }

    @Test
    public void testOkButtonHandlerEmptyRuleName() throws Exception {
        this.testOkButtonHandler(" ");
    }

    @Test
    public void testOkButtonHandlerNullRuleName() throws Exception {
        this.testOkButtonHandler(null);
    }

    private void testOkButtonHandler(String ruleName) {
        ((Select)Mockito.doReturn((Object)ruleName).when((Object)this.ruleNameSelector)).getValue();
        this.creator.createOkButton(this.ruleSelectionEvent);
        ((Button)Mockito.verify((Object)this.button)).addClickHandler((ClickHandler)this.clickCaptor.capture());
        ((ClickHandler)this.clickCaptor.getValue()).onClick(null);
        if (ruleName != null && !ruleName.trim().isEmpty()) {
            ((ScenarioWidgetComponentCreator)Mockito.verify((Object)this.creator, (VerificationMode)Mockito.never())).showSelectRuleNameWarning();
            ((RuleSelectionEvent)Mockito.verify((Object)this.ruleSelectionEvent)).ruleSelected(ruleName.trim());
        } else {
            ((ScenarioWidgetComponentCreator)Mockito.verify((Object)this.creator)).showSelectRuleNameWarning();
            ((RuleSelectionEvent)Mockito.verify((Object)this.ruleSelectionEvent, (VerificationMode)Mockito.never())).ruleSelected(Matchers.anyString());
        }
    }
}

