/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.models.testscenarios.shared.ExecutionTrace;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.models.testscenarios.shared.VerifyField;
import org.drools.workbench.screens.testscenario.client.EditableCollectionBox;
import org.drools.workbench.screens.testscenario.client.EditableTextBox;
import org.drools.workbench.screens.testscenario.client.VerifyFieldConstraintEditor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.callbacks.Callback;

@RunWith(value=GwtMockitoTestRunner.class)
public class VerifyFieldConstraintEditorTest {
    private static final String FACT_TYPE = "Person";
    @Mock
    private Callback<String> callback;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private Scenario scenario;
    @Mock
    private ExecutionTrace executionTrace;
    private VerifyField field;
    private VerifyFieldConstraintEditor editor;

    @Test
    public void testNatureWithNewExpectation() {
        this.field = new VerifyField("age", "", "");
        Mockito.when((Object)this.oracle.getFieldType(FACT_TYPE, this.field.getFieldName())).thenReturn((Object)"Integer");
        this.editor = new VerifyFieldConstraintEditor(FACT_TYPE, this.callback, this.field, this.oracle, this.scenario, this.executionTrace);
        Assert.assertEquals((long)this.field.getNature(), (long)1L);
    }

    @Test
    public void testNatureWithExistingLiteralExpectation() {
        this.field = new VerifyField("age", "18", "==");
        this.field.setNature(1L);
        Mockito.when((Object)this.oracle.getFieldType(FACT_TYPE, this.field.getFieldName())).thenReturn((Object)"Integer");
        this.editor = new VerifyFieldConstraintEditor(FACT_TYPE, this.callback, this.field, this.oracle, this.scenario, this.executionTrace);
        Assert.assertEquals((long)this.field.getNature(), (long)1L);
    }

    @Test
    public void testNatureWithExistingCollectionExpectation() {
        this.field = new VerifyField("age", "=[18, 21]", "==");
        this.field.setNature(1L);
        Mockito.when((Object)this.oracle.getFieldType(FACT_TYPE, this.field.getFieldName())).thenReturn((Object)"Integer");
        this.editor = new VerifyFieldConstraintEditor(FACT_TYPE, this.callback, this.field, this.oracle, this.scenario, this.executionTrace);
        Assert.assertEquals((long)this.field.getNature(), (long)1L);
    }

    @Test
    public void testNatureWithExistingLegacyVariableExpectation() {
        this.field = new VerifyField("age", "=$age", "==");
        this.field.setNature(0L);
        Mockito.when((Object)this.oracle.getFieldType(FACT_TYPE, this.field.getFieldName())).thenReturn((Object)"Integer");
        this.editor = new VerifyFieldConstraintEditor(FACT_TYPE, this.callback, this.field, this.oracle, this.scenario, this.executionTrace);
        Assert.assertEquals((long)this.field.getNature(), (long)2L);
    }

    @Test
    public void testNatureWithExistingVariableExpectation() {
        this.field = new VerifyField("age", "=$age", "==");
        this.field.setNature(2L);
        Mockito.when((Object)this.oracle.getFieldType(FACT_TYPE, this.field.getFieldName())).thenReturn((Object)"Integer");
        this.editor = new VerifyFieldConstraintEditor(FACT_TYPE, this.callback, this.field, this.oracle, this.scenario, this.executionTrace);
        Assert.assertEquals((long)this.field.getNature(), (long)2L);
    }

    @Test
    public void testTextBoxEditorWhenTypeIsCollection() {
        this.field = new VerifyField("age", "=$age", "==");
        Mockito.when((Object)this.oracle.getFieldType(FACT_TYPE, this.field.getFieldName())).thenReturn((Object)"Integer");
        this.editor = new VerifyFieldConstraintEditor(FACT_TYPE, this.callback, this.field, this.oracle, this.scenario, this.executionTrace);
        Assert.assertTrue((boolean)(this.editor.textBoxEditor("Collection") instanceof EditableCollectionBox));
    }

    @Test
    public void testTextBoxEditorWhenTypeIsNotCollection() {
        this.field = new VerifyField("age", "=$age", "==");
        Mockito.when((Object)this.oracle.getFieldType(FACT_TYPE, this.field.getFieldName())).thenReturn((Object)"Integer");
        this.editor = new VerifyFieldConstraintEditor(FACT_TYPE, this.callback, this.field, this.oracle, this.scenario, this.executionTrace);
        Assert.assertTrue((boolean)(this.editor.textBoxEditor("String") instanceof EditableTextBox));
    }
}

