/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.client;

import org.drools.workbench.models.testscenarios.shared.VerifyScorecardScore;
import org.drools.workbench.screens.testscenario.client.VerifyScorecardScoreWidget;
import org.drools.workbench.screens.testscenario.client.VerifyScorecardScoreWidgetView;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class VerifyScorecardScoreWidgetTest {
    @Mock
    VerifyScorecardScoreWidgetView view;

    @Test
    public void setPresenter() {
        VerifyScorecardScoreWidget presenter = this.makeWidget(new VerifyScorecardScore(Double.valueOf(10.0)), false);
        ((VerifyScorecardScoreWidgetView)Mockito.verify((Object)this.view)).setPresenter(presenter);
    }

    @Test
    public void setValue() {
        this.makeWidget(new VerifyScorecardScore(Double.valueOf(10.0)), false);
        ((VerifyScorecardScoreWidgetView)Mockito.verify((Object)this.view)).setValue("10.0");
    }

    @Test
    public void setDoNotShowResult() {
        this.makeWidget(new VerifyScorecardScore(Double.valueOf(10.0)), false);
        ((VerifyScorecardScoreWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showFailed(Matchers.anyString());
        ((VerifyScorecardScoreWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showPassed();
    }

    @Test
    public void testShowPassed() {
        VerifyScorecardScore verifyScorecardScore = new VerifyScorecardScore();
        verifyScorecardScore.setExpected(Double.valueOf(10.0));
        verifyScorecardScore.setResult(Double.valueOf(10.0));
        this.makeWidget(verifyScorecardScore, true);
        ((VerifyScorecardScoreWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showFailed(Matchers.anyString());
        ((VerifyScorecardScoreWidgetView)Mockito.verify((Object)this.view)).showPassed();
    }

    @Test
    public void testShowFailed() {
        VerifyScorecardScore verifyScorecardScore = new VerifyScorecardScore();
        verifyScorecardScore.setExpected(Double.valueOf(10.0));
        verifyScorecardScore.setResult(Double.valueOf(20.0));
        this.makeWidget(verifyScorecardScore, true);
        ((VerifyScorecardScoreWidgetView)Mockito.verify((Object)this.view)).showFailed("20.0");
        ((VerifyScorecardScoreWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showPassed();
    }

    private VerifyScorecardScoreWidget makeWidget(VerifyScorecardScore verifyScorecardScore, boolean showResults) {
        return new VerifyScorecardScoreWidget(verifyScorecardScore, showResults){

            protected VerifyScorecardScoreWidgetView makeView() {
                return VerifyScorecardScoreWidgetTest.this.view;
            }
        };
    }
}

