/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.client.page.audit;

import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.workbench.models.testscenarios.shared.ExecutionTrace;
import org.drools.workbench.screens.testscenario.client.page.audit.AuditPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;

@WithClassesToStub(value={RootPanel.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class AuditPageTest {
    @Captor
    ArgumentCaptor<List> listArgumentCaptor;
    @Mock
    private AuditPage.AuditPageView auditPageView;
    private AuditPage auditPage;

    @Before
    public void setUp() throws Exception {
        this.auditPage = new AuditPage(this.auditPageView);
    }

    @Test
    public void testShowFiredRulesAuditLog() {
        HashSet<String> logMessages = new HashSet<String>(){
            {
                this.add("rule 1 fired");
                this.add("rule 2 fired");
            }
        };
        this.auditPage.showFiredRulesAuditLog((Set)logMessages);
        ((AuditPage.AuditPageView)Mockito.verify((Object)this.auditPageView)).showAuditLog((Set)logMessages);
    }

    @Test
    public void testShowFiredRules() {
        ExecutionTrace executionTrace = new ExecutionTrace();
        String[] rulesFired = new String[]{"rule name"};
        executionTrace.setRulesFired(rulesFired);
        this.auditPage.showFiredRules(executionTrace);
        ((AuditPage.AuditPageView)Mockito.verify((Object)this.auditPageView)).showFiredRules((List)this.listArgumentCaptor.capture());
        List list = (List)this.listArgumentCaptor.getValue();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"rule name", list.get(0));
    }

    @Test
    public void testShowFiredRulesDontShowIfThereIsNoRules() {
        ExecutionTrace executionTrace = new ExecutionTrace();
        executionTrace.setRulesFired(null);
        this.auditPage.showFiredRules(executionTrace);
        ((AuditPage.AuditPageView)Mockito.verify((Object)this.auditPageView)).showFiredRules((List)this.listArgumentCaptor.capture());
        Assert.assertTrue((boolean)((List)this.listArgumentCaptor.getValue()).isEmpty());
    }
}

