/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.client.page.audit;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLDivElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.testscenario.client.page.audit.AuditPageViewImpl;
import org.drools.workbench.screens.testscenario.client.page.audit.AuditTable;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class AuditPageViewImplTest {
    @Mock
    private HTMLDivElement root;
    @Mock
    private AuditTable firedRulesTable;
    @Mock
    private AuditTable auditLogTable;
    @Captor
    private ArgumentCaptor<List<String>> collectionCaptor;
    private AuditPageViewImpl testedView;

    @Before
    public void setUp() throws Exception {
        this.testedView = new AuditPageViewImpl(this.root, this.firedRulesTable, this.auditLogTable);
    }

    @Test
    public void testAuditLog() throws Exception {
        Set<String> logMessages = Collections.singleton("log 1");
        this.testedView.showAuditLog(logMessages);
        ((AuditTable)Mockito.verify((Object)this.auditLogTable)).showItems(logMessages);
    }

    @Test
    public void testFiredRules() throws Exception {
        ArrayList<String> rulesFired = new ArrayList<String>();
        rulesFired.add("rule 1");
        rulesFired.add("rule 2");
        this.testedView.showFiredRules(rulesFired);
        ((AuditTable)Mockito.verify((Object)this.firedRulesTable)).showItems((Collection)this.collectionCaptor.capture());
        Assertions.assertThat((List)((List)this.collectionCaptor.getValue())).containsAll(rulesFired);
    }
}

