/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.client.page.settings;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashSet;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.client.page.settings.ScorecardSelector;
import org.drools.workbench.screens.testscenario.client.page.settings.ScorecardSelectorView;
import org.drools.workbench.screens.testscenario.client.resources.i18n.TestScenarioConstants;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.refactoring.service.ScoreCardServiceLoader;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScorecardSelectorTest {
    @Mock
    private TestScenarioConstants constants;
    @Mock
    private ScoreCardServiceLoader scoreCardServiceLoader;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private ScorecardSelectorView view;
    private ScorecardSelector presenter;

    @Before
    public void setUp() throws Exception {
        ((AuthorizationManager)Mockito.doReturn((Object)true).when((Object)this.authorizationManager)).authorize((Resource)Matchers.any(ResourceRef.class), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.any(User.class));
        this.presenter = new ScorecardSelector((Caller)new CallerMock((Object)this.scoreCardServiceLoader), this.authorizationManager, this.sessionInfo, this.view);
    }

    @Test
    public void fillDropdown() {
        Path path = (Path)Mockito.mock(Path.class);
        Scenario scenario = new Scenario();
        scenario.setPackageName("org.test");
        HashSet<String> scoreCardNames = new HashSet<String>();
        scoreCardNames.add("1");
        scoreCardNames.add("2");
        ((ScoreCardServiceLoader)Mockito.doReturn(scoreCardNames).when((Object)this.scoreCardServiceLoader)).find(path, "org.test");
        this.presenter.init(path, scenario);
        ((ScorecardSelectorView)Mockito.verify((Object)this.view)).clear();
        ((ScorecardSelectorView)Mockito.verify((Object)this.view)).add("- SelectScoreCard -");
        ((ScorecardSelectorView)Mockito.verify((Object)this.view)).add("1");
        ((ScorecardSelectorView)Mockito.verify((Object)this.view)).add("2");
        ((ScorecardSelectorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setSelected(Matchers.anyString());
    }

    @Test
    public void setSelected() {
        Path path = (Path)Mockito.mock(Path.class);
        Scenario scenario = new Scenario();
        scenario.setPackageName("org.test");
        scenario.setModelName("selected");
        HashSet<String> scoreCardNames = new HashSet<String>();
        scoreCardNames.add("something");
        scoreCardNames.add("selected");
        ((ScoreCardServiceLoader)Mockito.doReturn(scoreCardNames).when((Object)this.scoreCardServiceLoader)).find(path, "org.test");
        this.presenter.init(path, scenario);
        ((ScorecardSelectorView)Mockito.verify((Object)this.view)).setSelected("selected");
    }

    @Test
    public void onValueSelected() {
        Path path = (Path)Mockito.mock(Path.class);
        Scenario scenario = new Scenario();
        scenario.setPackageName("org.test");
        HashSet<String> scoreCardNames = new HashSet<String>();
        scoreCardNames.add("something");
        scoreCardNames.add("selected");
        ((ScoreCardServiceLoader)Mockito.doReturn(scoreCardNames).when((Object)this.scoreCardServiceLoader)).find(path, "org.test");
        this.presenter.init(path, scenario);
        this.presenter.onValueSelected("selected");
        Assert.assertEquals((Object)"selected", (Object)scenario.getModelName());
    }
}

