/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.drools.workbench.models.testscenarios.shared.ExecutionTrace;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.client.ScenarioEditorPresenter;
import org.drools.workbench.screens.testscenario.client.ScenarioEditorView;
import org.drools.workbench.screens.testscenario.client.ScenarioParentWidget;
import org.drools.workbench.screens.testscenario.client.TestRunFailedErrorCallback;
import org.drools.workbench.screens.testscenario.client.page.audit.AuditPage;
import org.drools.workbench.screens.testscenario.client.page.settings.SettingsPage;
import org.drools.workbench.screens.testscenario.client.resources.i18n.TestScenarioConstants;
import org.drools.workbench.screens.testscenario.client.type.TestScenarioResourceType;
import org.drools.workbench.screens.testscenario.model.TestScenarioModelContent;
import org.drools.workbench.screens.testscenario.model.TestScenarioResult;
import org.drools.workbench.screens.testscenario.service.ScenarioTestEditorService;
import org.guvnor.common.services.project.categories.Decision;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.docks.DefaultEditorDock;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilderImpl;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.validation.AssetUpdateValidator;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.kie.workbench.common.workbench.client.test.TestReportingDocksHandler;
import org.kie.workbench.common.workbench.client.test.TestRunnerReportingPanel;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.client.workbench.widgets.multipage.MultiPageEditor;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.promise.SyncPromises;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioEditorPresenterTest {
    @Mock
    protected AlertsButtonMenuItemBuilder alertsButtonMenuItemBuilder;
    @Mock
    protected MenuItem alertsButtonMenuItem;
    @Mock
    CommonConstants commonConstants;
    @Mock
    TestRunnerReportingPanel testRunnerReportingPanel;
    @Mock
    TestReportingDocksHandler testReportingDocksHandler;
    @Mock
    DefaultEditorDock docks;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private EventSourceMock showTestPanelEvent;
    @Mock
    private EventSourceMock hideTestPanelEvent;
    @Captor
    private ArgumentCaptor<Scenario> scenarioArgumentCaptor;
    @Mock
    private KieEditorWrapperView kieView;
    @Mock
    private ScenarioEditorView view;
    @Mock
    private VersionRecordManager versionRecordManager;
    @Mock
    private OverviewWidgetPresenter overviewWidget;
    @Mock
    private MultiPageEditor multiPage;
    @Mock
    private ImportsWidgetPresenter importsWidget;
    @Mock
    private User user;
    @Mock
    private ScenarioTestEditorService service;
    @Mock
    private BasicFileMenuBuilder menuBuilder;
    @Spy
    @InjectMocks
    private FileMenuBuilderImpl fileMenuBuilder;
    @Mock
    private ProjectController projectController;
    @Mock
    private WorkspaceProjectContext workbenchContext;
    @Mock
    private SettingsPage settingsPage;
    @Mock
    private AuditPage auditPage;
    protected Promises promises;
    @Mock
    private EventSourceMock<NotificationEvent> notificationEventMock;
    @Mock
    private PerspectiveManager perspectiveManager;
    private CallerMock<ScenarioTestEditorService> fakeService;
    private ScenarioEditorPresenter editor;
    private Scenario scenario;
    private Overview overview;
    private Scenario scenarioRunResult = null;

    @Before
    public void setUp() throws Exception {
        this.promises = new SyncPromises();
        AsyncPackageDataModelOracleFactory modelOracleFactory = (AsyncPackageDataModelOracleFactory)Mockito.mock(AsyncPackageDataModelOracleFactory.class);
        this.fakeService = new CallerMock((Object)this.service);
        this.editor = (ScenarioEditorPresenter)Mockito.spy((Object)new ScenarioEditorPresenter(this.view, this.user, this.importsWidget, (Caller)this.fakeService, new TestScenarioResourceType(new Decision()), modelOracleFactory, this.settingsPage, this.auditPage, this.testRunnerReportingPanel, this.testReportingDocksHandler, (Event)this.showTestPanelEvent, (Event)this.hideTestPanelEvent){
            {
                this.docks = ScenarioEditorPresenterTest.this.docks;
                this.kieView = ScenarioEditorPresenterTest.this.kieView;
                this.versionRecordManager = ScenarioEditorPresenterTest.this.versionRecordManager;
                this.overviewWidget = ScenarioEditorPresenterTest.this.overviewWidget;
                this.notification = ScenarioEditorPresenterTest.this.notificationEventMock;
                this.fileMenuBuilder = ScenarioEditorPresenterTest.this.fileMenuBuilder;
                this.projectController = ScenarioEditorPresenterTest.this.projectController;
                this.workbenchContext = ScenarioEditorPresenterTest.this.workbenchContext;
                this.versionRecordManager = ScenarioEditorPresenterTest.this.versionRecordManager;
                this.alertsButtonMenuItemBuilder = ScenarioEditorPresenterTest.this.alertsButtonMenuItemBuilder;
                this.perspectiveManager = ScenarioEditorPresenterTest.this.perspectiveManager;
                this.placeManager = ScenarioEditorPresenterTest.this.placeManager;
                this.promises = ScenarioEditorPresenterTest.this.promises;
            }

            protected Command getSaveAndRename() {
                return (Command)Mockito.mock(Command.class);
            }
        });
        ((ScenarioEditorPresenter)Mockito.doNothing().when((Object)this.editor)).addDownloadMenuItem((FileMenuBuilder)Mockito.any());
        this.scenarioRunResult = new Scenario();
        this.scenario = new Scenario();
        this.overview = new Overview();
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"userName");
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn(Optional.empty());
        Mockito.when((Object)this.workbenchContext.getActiveWorkspaceProject()).thenReturn(Optional.empty());
        TestScenarioModelContent testScenarioModelContent = new TestScenarioModelContent(this.scenario, this.overview, "org.test", new PackageDataModelOracleBaselinePayload());
        Mockito.when((Object)this.service.loadContent((Path)Mockito.any())).thenReturn((Object)testScenarioModelContent);
        TestScenarioResult result = new TestScenarioResult(this.scenarioRunResult, Collections.EMPTY_SET, (TestResultMessage)Mockito.mock(TestResultMessage.class));
        Mockito.when((Object)this.service.runScenario((String)Mockito.eq((Object)"userName"), (Path)Mockito.any(), (Scenario)Mockito.eq((Object)this.scenario))).thenReturn((Object)result);
        AsyncPackageDataModelOracle dmo = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        Mockito.when((Object)modelOracleFactory.makeAsyncPackageDataModelOracle((Path)Mockito.any(), (HasImports)Mockito.any(), (PackageDataModelOracleBaselinePayload)Mockito.any())).thenReturn((Object)dmo);
        Mockito.when((Object)this.alertsButtonMenuItemBuilder.build()).thenReturn((Object)this.alertsButtonMenuItem);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)((PerspectiveActivity)Mockito.mock(PerspectiveActivity.class)));
    }

    @Test
    public void showDiagramEditorDocks() {
        DefaultPlaceRequest place = new DefaultPlaceRequest("ScenarioEditorPresenter");
        this.editor.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)place);
        this.editor.onShowDiagramEditorDocks(new PlaceGainFocusEvent((PlaceRequest)place));
        ((EventSourceMock)Mockito.verify((Object)this.showTestPanelEvent)).fire(Mockito.any());
    }

    @Test
    public void showDiagramEditorDocksWrongPlaceName() {
        this.editor.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)new DefaultPlaceRequest("ScenarioEditorPresenter"));
        this.editor.onShowDiagramEditorDocks(new PlaceGainFocusEvent((PlaceRequest)new DefaultPlaceRequest("wrong name")));
        ((EventSourceMock)Mockito.verify((Object)this.showTestPanelEvent, (VerificationMode)Mockito.never())).fire(Mockito.any());
    }

    @Test
    public void testSimple() throws Exception {
        ((ScenarioEditorView)Mockito.verify((Object)this.view)).setPresenter((ScenarioEditorView.Presenter)Mockito.any(ScenarioEditorPresenter.class));
    }

    @Test
    public void hideDiagramEditorDocks() {
        DefaultPlaceRequest place = new DefaultPlaceRequest("ScenarioEditorPresenter");
        this.editor.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)place);
        ((TestRunnerReportingPanel)Mockito.verify((Object)this.testRunnerReportingPanel)).reset();
        this.editor.onHideDocks(new PlaceHiddenEvent((PlaceRequest)place));
        ((EventSourceMock)Mockito.verify((Object)this.hideTestPanelEvent)).fire(Mockito.any());
        ((TestRunnerReportingPanel)Mockito.verify((Object)this.testRunnerReportingPanel, (VerificationMode)Mockito.times((int)2))).reset();
    }

    @Test
    public void hideDiagramEditorDocksWrongPlaceName() {
        this.editor.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)new DefaultPlaceRequest("ScenarioEditorPresenter"));
        this.editor.onHideDocks(new PlaceHiddenEvent((PlaceRequest)new DefaultPlaceRequest("wrong name")));
        ((EventSourceMock)Mockito.verify((Object)this.hideTestPanelEvent, (VerificationMode)Mockito.never())).fire(Mockito.any());
    }

    @Test
    public void testRunScenarioAndSave() throws Exception {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)path);
        this.editor.onStartup(path, placeRequest);
        Mockito.reset((Object[])new ScenarioEditorView[]{this.view});
        Mockito.reset((Object[])new ImportsWidgetPresenter[]{this.importsWidget});
        this.editor.onRunScenario();
        ((ImportsWidgetPresenter)Mockito.verify((Object)this.importsWidget)).setContent((AsyncPackageDataModelOracle)Mockito.any(AsyncPackageDataModelOracle.class), (Imports)Mockito.eq((Object)this.scenarioRunResult.getImports()), Mockito.anyBoolean());
        this.editor.save("Commit message");
        ((ScenarioTestEditorService)Mockito.verify((Object)this.service)).save((Path)Mockito.any(Path.class), (Object)((Scenario)this.scenarioArgumentCaptor.capture()), (Object)((Metadata)Mockito.any()), Mockito.anyString());
        Assert.assertEquals((Object)this.scenarioRunResult, (Object)this.scenarioArgumentCaptor.getValue());
    }

    @Test
    public void testEmptyScenario() throws Exception {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)path);
        this.editor.onStartup(path, placeRequest);
        ((ScenarioEditorView)Mockito.verify((Object)this.view)).renderFixtures((Path)Mockito.eq((Object)path), (AsyncPackageDataModelOracle)Mockito.any(AsyncPackageDataModelOracle.class), (Scenario)Mockito.eq((Object)this.scenario));
    }

    @Test
    public void testKiePageRefreshAfterContentLoaded() throws Exception {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)path);
        this.editor.loadContent();
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieView)).addPage((Page)this.settingsPage);
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieView)).addPage((Page)this.auditPage);
        ((SettingsPage)Mockito.verify((Object)this.settingsPage)).refresh((ScenarioParentWidget)this.view, (Path)path, this.scenario);
    }

    @Test
    public void testRunScenario() throws Exception {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)path);
        this.editor.onStartup(path, placeRequest);
        Mockito.reset((Object[])new ScenarioEditorView[]{this.view});
        this.editor.onRunScenario();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.view});
        ((ScenarioEditorView)inOrder.verify((Object)this.view)).showBusyIndicator(TestScenarioConstants.INSTANCE.BuildingAndRunningScenario());
        ((ScenarioEditorView)inOrder.verify((Object)this.view)).showResults();
        ((ScenarioEditorView)inOrder.verify((Object)this.view)).hideBusyIndicator();
        ((SettingsPage)Mockito.verify((Object)this.settingsPage)).refresh((ScenarioParentWidget)this.view, (Path)path, this.scenario);
        ((AuditPage)Mockito.verify((Object)this.auditPage)).showFiredRulesAuditLog(Collections.emptySet());
        ((AuditPage)Mockito.verify((Object)this.auditPage)).showFiredRules((ExecutionTrace)Matchers.notNull(ExecutionTrace.class));
    }

    @Test
    public void testRunScenarioFail() throws Exception {
        TestRunFailedErrorCallback callback = (TestRunFailedErrorCallback)Mockito.mock(TestRunFailedErrorCallback.class);
        ((TestRunFailedErrorCallback)Mockito.doReturn((Object)true).when((Object)callback)).error((Message)Mockito.any(Message.class), (Throwable)Mockito.any(RuntimeException.class));
        ((ScenarioEditorPresenter)Mockito.doReturn((Object)callback).when((Object)this.editor)).getTestRunFailedCallback();
        ((ScenarioTestEditorService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("some problem")}).when((Object)this.service)).runScenario((String)Mockito.any(), (Path)Mockito.any(), (Scenario)Mockito.any());
        this.editor.onRunScenario();
        ((TestRunFailedErrorCallback)Mockito.verify((Object)callback)).error((Message)Mockito.any(), (Throwable)Mockito.any(RuntimeException.class));
        ((ScenarioEditorView)Mockito.verify((Object)this.view)).showBusyIndicator(TestScenarioConstants.INSTANCE.BuildingAndRunningScenario());
    }

    @Test
    public void testMakeMenuBar() {
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of((WorkspaceProject)Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)true)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Mockito.any());
        this.editor.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addSave((MenuItem)Mockito.any());
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addCopy((Path)Mockito.any(), (Validator)Mockito.any());
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addRename((Command)Mockito.any(Command.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addDelete((Path)Mockito.any(), (Validator)Mockito.any());
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
        ((ScenarioEditorPresenter)Mockito.verify((Object)this.editor)).addDownloadMenuItem((FileMenuBuilder)this.fileMenuBuilder);
    }

    @Test
    public void testMakeMenuBarWithoutUpdateProjectPermission() {
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of((WorkspaceProject)Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)false)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Mockito.any());
        this.editor.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addSave((Command)Mockito.any(Command.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addCopy((Path)Mockito.any(Path.class), (Validator)Mockito.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addRename((Path)Mockito.any(Path.class), (Validator)Mockito.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addDelete((Path)Mockito.any(Path.class), (Validator)Mockito.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
    }

    @Test
    public void testGetContentSupplier() throws Exception {
        Scenario content = (Scenario)Mockito.mock(Scenario.class);
        ((ScenarioEditorPresenter)Mockito.doReturn((Object)content).when((Object)this.editor)).getScenario();
        Supplier contentSupplier = this.editor.getContentSupplier();
        Assert.assertEquals((Object)content, contentSupplier.get());
    }

    @Test
    public void testGetSaveAndRenameServiceCaller() throws Exception {
        Caller serviceCaller = this.editor.getSaveAndRenameServiceCaller();
        Assert.assertEquals(this.fakeService, (Object)serviceCaller);
    }
}

