/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.client.page.settings;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.client.RuleSelectionEvent;
import org.drools.workbench.screens.testscenario.client.ScenarioParentWidget;
import org.drools.workbench.screens.testscenario.client.ScenarioWidgetComponentCreator;
import org.drools.workbench.screens.testscenario.client.page.settings.ConfigWidget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class, RootPanel.class})
public class ConfigWidgetTest {
    @Mock
    private ScenarioWidgetComponentCreator scenarioWidgetComponentCreator;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private Button addButton;
    @Mock
    private Button removeButton;
    @Mock
    private ListBox configuredRules;
    @Mock
    private ListBox configurationType;
    @Mock
    private ScenarioParentWidget scenarioParentWidget;
    @Mock
    private Path path;
    @Mock
    private Scenario scenario;
    @Captor
    private ArgumentCaptor<ClickHandler> clickCaptor;
    @Captor
    private ArgumentCaptor<RuleSelectionEvent> selectedRuleEventCaptor;
    @Captor
    private ArgumentCaptor<ChangeHandler> changeHandlerCaptor;
    private ConfigWidget configWidget;

    @Before
    public void setUp() throws Exception {
        this.configWidget = new ConfigWidget(this.scenarioWidgetComponentCreator, this.oracle, this.addButton, this.removeButton, this.configuredRules, this.configurationType);
    }

    @Test
    public void testInit() throws Exception {
        this.configWidget.init(this.scenarioParentWidget, this.path, this.scenario);
        ((ScenarioWidgetComponentCreator)Mockito.verify((Object)this.scenarioWidgetComponentCreator)).reset(this.scenarioParentWidget, this.path, this.oracle, this.scenario);
    }

    @Test
    public void testShowOneAllowedRule() {
        this.configWidget.init(this.scenarioParentWidget, this.path, this.scenario);
        Mockito.when((Object)this.scenario.getRules()).thenReturn(Collections.singletonList("rule 1"));
        Mockito.when((Object)this.scenario.isInclusive()).thenReturn((Object)true);
        this.configWidget.show();
        ((ListBox)Mockito.verify((Object)this.configuredRules)).clear();
        ((ListBox)Mockito.verify((Object)this.configuredRules)).addItem("rule 1");
        ((ListBox)Mockito.verify((Object)this.configurationType)).setSelectedIndex(0);
        ((ListBox)Mockito.verify((Object)this.configuredRules)).setVisible(true);
        ((Button)Mockito.verify((Object)this.addButton)).setVisible(true);
        ((Button)Mockito.verify((Object)this.removeButton)).setVisible(true);
    }

    @Test
    public void testShowOnePreventedRule() {
        this.configWidget.init(this.scenarioParentWidget, this.path, this.scenario);
        Mockito.when((Object)this.scenario.getRules()).thenReturn(Collections.singletonList("rule 1"));
        Mockito.when((Object)this.scenario.isInclusive()).thenReturn((Object)false);
        this.configWidget.show();
        ((ListBox)Mockito.verify((Object)this.configuredRules)).clear();
        ((ListBox)Mockito.verify((Object)this.configuredRules)).addItem("rule 1");
        ((ListBox)Mockito.verify((Object)this.configurationType)).setSelectedIndex(1);
        ((ListBox)Mockito.verify((Object)this.configuredRules)).setVisible(true);
        ((Button)Mockito.verify((Object)this.addButton)).setVisible(true);
        ((Button)Mockito.verify((Object)this.removeButton)).setVisible(true);
    }

    @Test
    public void testShowNoRule() {
        this.configWidget.init(this.scenarioParentWidget, this.path, this.scenario);
        Mockito.when((Object)this.scenario.getRules()).thenReturn(Collections.emptyList());
        this.configWidget.show();
        ((ListBox)Mockito.verify((Object)this.configuredRules)).clear();
        ((ListBox)Mockito.verify((Object)this.configurationType)).setSelectedIndex(2);
        ((ListBox)Mockito.verify((Object)this.configuredRules)).setVisible(false);
        ((Button)Mockito.verify((Object)this.addButton)).setVisible(false);
        ((Button)Mockito.verify((Object)this.removeButton)).setVisible(false);
    }

    @Test
    public void testAddButtonClickHandler() throws Exception {
        ArrayList rules = new ArrayList();
        Mockito.when((Object)this.scenario.getRules()).thenReturn(rules);
        this.configWidget.init(this.scenarioParentWidget, this.path, this.scenario);
        this.configWidget.setupHandlers();
        ((Button)Mockito.verify((Object)this.addButton)).addClickHandler((ClickHandler)this.clickCaptor.capture());
        ((ClickHandler)this.clickCaptor.getValue()).onClick(null);
        ((ScenarioWidgetComponentCreator)Mockito.verify((Object)this.scenarioWidgetComponentCreator)).getRuleSelectionWidget((RuleSelectionEvent)this.selectedRuleEventCaptor.capture());
        ((RuleSelectionEvent)this.selectedRuleEventCaptor.getValue()).ruleSelected("rule 1");
        Assertions.assertThat(rules).containsExactly((Object[])new String[]{"rule 1"});
        ((ListBox)Mockito.verify((Object)this.configuredRules)).addItem("rule 1");
    }

    @Test
    public void testRemoveButtonHandler() throws Exception {
        ArrayList<String> rules = new ArrayList<String>(){
            {
                this.add("rule 1");
            }
        };
        Mockito.when((Object)this.scenario.getRules()).thenReturn((Object)rules);
        Mockito.when((Object)this.configuredRules.getSelectedIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.configuredRules.getItemText(0)).thenReturn((Object)"rule 1");
        this.configWidget.init(this.scenarioParentWidget, this.path, this.scenario);
        this.configWidget.setupHandlers();
        ((Button)Mockito.verify((Object)this.removeButton)).addClickHandler((ClickHandler)this.clickCaptor.capture());
        ((ClickHandler)this.clickCaptor.getValue()).onClick(null);
        Assertions.assertThat((List)rules).isEmpty();
        ((ListBox)Mockito.verify((Object)this.configuredRules)).removeItem(0);
    }

    @Test
    public void testChangeAllowedRules() throws Exception {
        Mockito.when((Object)this.configurationType.getSelectedIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.configurationType.getValue(0)).thenReturn((Object)"inc");
        this.configWidget.init(this.scenarioParentWidget, this.path, this.scenario);
        this.configWidget.setupHandlers();
        ((ListBox)Mockito.verify((Object)this.configurationType)).addChangeHandler((ChangeHandler)this.changeHandlerCaptor.capture());
        ((ChangeHandler)this.changeHandlerCaptor.getValue()).onChange(null);
        ((Scenario)Mockito.verify((Object)this.scenario)).setInclusive(true);
        ((Button)Mockito.verify((Object)this.addButton)).setVisible(true);
        ((Button)Mockito.verify((Object)this.removeButton)).setVisible(true);
        ((ListBox)Mockito.verify((Object)this.configuredRules)).setVisible(true);
    }

    @Test
    public void testChangePreventedRules() throws Exception {
        Mockito.when((Object)this.configurationType.getSelectedIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.configurationType.getValue(1)).thenReturn((Object)"exc");
        this.configWidget.init(this.scenarioParentWidget, this.path, this.scenario);
        this.configWidget.setupHandlers();
        ((ListBox)Mockito.verify((Object)this.configurationType)).addChangeHandler((ChangeHandler)this.changeHandlerCaptor.capture());
        ((ChangeHandler)this.changeHandlerCaptor.getValue()).onChange(null);
        ((Scenario)Mockito.verify((Object)this.scenario)).setInclusive(false);
        ((Button)Mockito.verify((Object)this.addButton)).setVisible(true);
        ((Button)Mockito.verify((Object)this.removeButton)).setVisible(true);
        ((ListBox)Mockito.verify((Object)this.configuredRules)).setVisible(true);
    }

    @Test
    public void testChangeAllowAllRules() throws Exception {
        ArrayList<String> rules = new ArrayList<String>(){
            {
                this.add("rule 1");
            }
        };
        Mockito.when((Object)this.scenario.getRules()).thenReturn((Object)rules);
        Mockito.when((Object)this.configurationType.getSelectedIndex()).thenReturn((Object)2);
        Mockito.when((Object)this.configurationType.getValue(2)).thenReturn((Object)"all");
        this.configWidget.init(this.scenarioParentWidget, this.path, this.scenario);
        this.configWidget.setupHandlers();
        ((ListBox)Mockito.verify((Object)this.configurationType)).addChangeHandler((ChangeHandler)this.changeHandlerCaptor.capture());
        ((ChangeHandler)this.changeHandlerCaptor.getValue()).onChange(null);
        Assertions.assertThat((List)rules).isEmpty();
        ((Button)Mockito.verify((Object)this.addButton)).setVisible(false);
        ((Button)Mockito.verify((Object)this.removeButton)).setVisible(false);
        ((ListBox)Mockito.verify((Object)this.configuredRules)).setVisible(false);
        ((ListBox)Mockito.verify((Object)this.configuredRules)).clear();
    }
}

