/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.client.page.settings;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Date;
import java.util.Optional;
import org.drools.workbench.models.testscenarios.shared.ExecutionTrace;
import org.drools.workbench.screens.testscenario.client.page.settings.ExecutionWidget;
import org.drools.workbench.screens.testscenario.client.resources.i18n.TestScenarioConstants;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.extras.datetimepicker.client.ui.DateTimePicker;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ExecutionWidgetTest {
    @Mock
    private ListBox dateConfigurationChoices;
    @Mock
    private DateTimePicker dateTimePicker;
    @Mock
    private ExecutionTrace executionTrace;
    private ExecutionWidget executionWidget;

    @Before
    public void setUp() {
        this.executionWidget = (ExecutionWidget)Mockito.spy((Object)new ExecutionWidget(this.dateTimePicker, this.dateConfigurationChoices));
    }

    @Test
    public void testSetup() {
        ChangeHandler changeHandler = (ChangeHandler)Mockito.mock(ChangeHandler.class);
        ((ExecutionWidget)Mockito.doReturn((Object)changeHandler).when((Object)this.executionWidget)).getChangeHandler();
        this.executionWidget.setup();
        ((ListBox)Mockito.verify((Object)this.dateConfigurationChoices)).addItem(TestScenarioConstants.INSTANCE.UseRealDateAndTime());
        ((ListBox)Mockito.verify((Object)this.dateConfigurationChoices)).addItem(TestScenarioConstants.INSTANCE.UseASimulatedDateAndTime());
        ((ListBox)Mockito.verify((Object)this.dateConfigurationChoices)).setSelectedIndex(0);
        ((ListBox)Mockito.verify((Object)this.dateConfigurationChoices)).addChangeHandler(changeHandler);
        ((DateTimePicker)Mockito.verify((Object)this.dateTimePicker)).setFormat("yyyy-MM-dd HH:mm");
    }

    @Test
    public void testShowTimePickerNotUsedBefore() {
        Mockito.when((Object)this.executionTrace.getScenarioSimulatedDate()).thenReturn(null);
        this.executionWidget.show(this.executionTrace);
        ((ListBox)Mockito.verify((Object)this.dateConfigurationChoices)).setSelectedIndex(0);
        ((DateTimePicker)Mockito.verify((Object)this.dateTimePicker)).setValue(null);
    }

    @Test
    public void testShowTimePickerUsedBefore() {
        Date date = new Date();
        Mockito.when((Object)this.executionTrace.getScenarioSimulatedDate()).thenReturn((Object)date);
        this.executionWidget.show(this.executionTrace);
        ((ListBox)Mockito.verify((Object)this.dateConfigurationChoices)).setSelectedIndex(1);
        ((DateTimePicker)Mockito.verify((Object)this.dateTimePicker)).setValue(date);
    }

    @Test
    public void testGetChangeHandlerWhenSelectedIndexIsZero() {
        ChangeEvent changeEvent = (ChangeEvent)Mockito.mock(ChangeEvent.class);
        ((ExecutionWidget)Mockito.doReturn(Optional.of(this.executionTrace)).when((Object)this.executionWidget)).getExecutionTrace();
        Mockito.when((Object)this.dateConfigurationChoices.getSelectedIndex()).thenReturn((Object)0);
        this.executionWidget.getChangeHandler().onChange(changeEvent);
        ((DateTimePicker)Mockito.verify((Object)this.dateTimePicker)).setValue(null);
        ((ExecutionTrace)Mockito.verify((Object)this.executionTrace)).setScenarioSimulatedDate(null);
    }

    @Test
    public void testGetChangeHandlerWhenSelectedIndexIsNotZero() {
        ChangeEvent changeEvent = (ChangeEvent)Mockito.mock(ChangeEvent.class);
        ((ExecutionWidget)Mockito.doReturn(Optional.of(this.executionTrace)).when((Object)this.executionWidget)).getExecutionTrace();
        Mockito.when((Object)this.dateConfigurationChoices.getSelectedIndex()).thenReturn((Object)1);
        this.executionWidget.getChangeHandler().onChange(changeEvent);
        ((DateTimePicker)Mockito.verify((Object)this.dateTimePicker, (VerificationMode)Mockito.never())).setValue((Date)Matchers.any());
        ((ExecutionTrace)Mockito.verify((Object)this.executionTrace, (VerificationMode)Mockito.never())).setScenarioSimulatedDate((Date)Matchers.any());
    }
}

