/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.api;

import java.util.HashSet;
import java.util.Set;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.commons.validation.PortablePreconditions;

@Portable
public class FactTypes {
    private final Set<FactType> factTypes;

    public FactTypes() {
        this(new HashSet<FactType>());
    }

    public FactTypes(@MapsTo(value="factTypes") Set<FactType> factTypes) {
        this.factTypes = (Set)PortablePreconditions.checkNotNull((String)"factTypes", factTypes);
    }

    public FactType getFactType(String factTypeName) {
        for (FactType factType : this.factTypes) {
            if (!factType.getName().equals(factTypeName)) continue;
            return factType;
        }
        return null;
    }

    public Set<FactType> getFactTypes() {
        return this.factTypes;
    }

    public String getFieldType(String factTypeName, String fieldName) {
        PortablePreconditions.checkNotNull((String)"factTypeName", (Object)factTypeName);
        PortablePreconditions.checkNotNull((String)"fieldName", (Object)fieldName);
        FactType factType = this.getFactType(factTypeName);
        if (factType == null) {
            return null;
        }
        for (Field field : factType.getFields()) {
            if (!field.getFieldName().equals(fieldName)) continue;
            return field.getType();
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (FactType key : this.factTypes) {
            builder.append(key.getName());
            builder.append("{");
            for (Field field : key.getFields()) {
                builder.append(field.toString());
                builder.append(", ");
            }
            builder.append("}");
        }
        return builder.toString();
    }

    public void add(FactType factType) {
        this.factTypes.add(factType);
    }

    @Portable
    public static class Field {
        private final String fieldName;
        private final String type;

        public Field(@MapsTo(value="fieldName") String fieldName, @MapsTo(value="type") String type) {
            this.fieldName = fieldName;
            this.type = type;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "Field{fieldName='" + this.fieldName + '\'' + ", type='" + this.type + '\'' + '}';
        }
    }

    @Portable
    public static class FactType {
        private final String name;
        private final Set<Field> fields;

        public FactType(@MapsTo(value="name") String name, @MapsTo(value="fields") Set<Field> fields) {
            this.name = name;
            this.fields = fields;
        }

        public String getName() {
            return this.name;
        }

        public Set<Field> getFields() {
            return this.fields;
        }
    }
}

