/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Action;
import org.drools.workbench.services.verifier.api.client.index.BRLAction;
import org.drools.workbench.services.verifier.api.client.index.Column;
import org.drools.workbench.services.verifier.api.client.index.Columns;
import org.drools.workbench.services.verifier.api.client.index.DataType;
import org.drools.workbench.services.verifier.api.client.index.Field;
import org.drools.workbench.services.verifier.api.client.index.FieldAction;
import org.drools.workbench.services.verifier.api.client.index.Index;
import org.drools.workbench.services.verifier.api.client.index.RetractAction;
import org.drools.workbench.services.verifier.api.client.index.Rule;
import org.drools.workbench.services.verifier.api.client.index.keys.Values;
import org.drools.workbench.services.verifier.api.client.index.matchers.Matcher;
import org.drools.workbench.services.verifier.plugin.client.builders.BuildException;
import org.drools.workbench.services.verifier.plugin.client.builders.BuilderFactory;
import org.drools.workbench.services.verifier.plugin.client.builders.Utils;
import org.uberfire.commons.validation.PortablePreconditions;

public class ActionBuilder {
    private BuilderFactory builderFactory;
    private final Index index;
    private List<DTCellValue52> row;
    private ActionCol52 actionCol;
    private Rule rule;
    private AnalyzerConfiguration configuration;
    private int columnIndex;

    public ActionBuilder(BuilderFactory builderFactory, Index index, AnalyzerConfiguration configuration) {
        this.builderFactory = (BuilderFactory)PortablePreconditions.checkNotNull((String)"builderFactory", (Object)builderFactory);
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
    }

    public static Comparable getValue(DTCellValue52 dtCellValue52) {
        switch (dtCellValue52.getDataType()) {
            case NUMERIC_BIGDECIMAL: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new BigDecimal(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_BIGINTEGER: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new BigInteger(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_BYTE: {
                return new Byte(dtCellValue52.getStringValue());
            }
            case NUMERIC_DOUBLE: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Double(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_FLOAT: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Float(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_INTEGER: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Integer(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_LONG: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Long(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_SHORT: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Short(dtCellValue52.getNumericValue().toString());
            }
            case DATE: {
                return dtCellValue52.getDateValue();
            }
            case BOOLEAN: {
                return dtCellValue52.getBooleanValue();
            }
        }
        String stringValue = dtCellValue52.getStringValue();
        if (stringValue == null) {
            return null;
        }
        if (stringValue.isEmpty()) {
            return null;
        }
        return stringValue;
    }

    public Action build() throws BuildException {
        if (this.actionCol instanceof BRLActionVariableColumn) {
            return this.addBRLAction();
        }
        if (this.actionCol instanceof ActionRetractFactCol52) {
            return this.addRetractAction();
        }
        if (this.actionCol instanceof ActionInsertFactCol52) {
            return this.addInsertFactAction((ActionInsertFactCol52)this.actionCol);
        }
        return this.addAction(this.actionCol, this.row.get(this.columnIndex));
    }

    private Action addInsertFactAction(ActionInsertFactCol52 actionCol) throws BuildException {
        this.builderFactory.getPatternResolver().with(this.rule).with((ActionCol52)actionCol).resolve();
        return this.addAction((ActionCol52)actionCol, this.row.get(this.columnIndex));
    }

    private Action addRetractAction() {
        return new RetractAction(this.getColumn(), this.getValues(this.row.get(this.columnIndex)), this.configuration);
    }

    private Action addBRLAction() {
        return new BRLAction(this.getColumn(), this.getValues(this.row.get(this.columnIndex)), this.configuration);
    }

    private Action addAction(ActionCol52 actionCol, DTCellValue52 visibleCellValue) throws BuildException {
        Field field = this.resolveField(actionCol);
        Action action = this.buildAction(field, visibleCellValue);
        field.getActions().add(action);
        return action;
    }

    private Field resolveField(ActionCol52 actionCol) throws BuildException {
        return this.builderFactory.getFieldResolver().with(this.rule).with((BaseColumn)actionCol).with(this.columnIndex).resolve();
    }

    private Action buildAction(Field field, DTCellValue52 visibleCellValue) {
        return new FieldAction(field, this.getColumn(), this.convert(visibleCellValue.getDataType()), this.getValues(visibleCellValue), this.configuration);
    }

    private DataType.DataTypes convert(DataType.DataTypes dataType) {
        switch (dataType) {
            case STRING: {
                return DataType.DataTypes.STRING;
            }
            case NUMERIC: {
                return DataType.DataTypes.NUMERIC;
            }
            case NUMERIC_BIGDECIMAL: {
                return DataType.DataTypes.NUMERIC_BIGDECIMAL;
            }
            case NUMERIC_BIGINTEGER: {
                return DataType.DataTypes.NUMERIC_BIGINTEGER;
            }
            case NUMERIC_BYTE: {
                return DataType.DataTypes.NUMERIC_BYTE;
            }
            case NUMERIC_DOUBLE: {
                return DataType.DataTypes.NUMERIC_DOUBLE;
            }
            case NUMERIC_FLOAT: {
                return DataType.DataTypes.NUMERIC_FLOAT;
            }
            case NUMERIC_INTEGER: {
                return DataType.DataTypes.NUMERIC_INTEGER;
            }
            case NUMERIC_LONG: {
                return DataType.DataTypes.NUMERIC_LONG;
            }
            case NUMERIC_SHORT: {
                return DataType.DataTypes.NUMERIC_SHORT;
            }
            case DATE: {
                return DataType.DataTypes.DATE;
            }
            case BOOLEAN: {
                return DataType.DataTypes.BOOLEAN;
            }
        }
        return null;
    }

    private Values getValues(DTCellValue52 visibleCellValue) {
        Comparable value = ActionBuilder.getValue(Utils.getRealCellValue((DTColumnConfig52)this.actionCol, visibleCellValue));
        if (value == null) {
            return new Values();
        }
        return new Values(new Comparable[]{value});
    }

    private Column getColumn() {
        return (Column)((Columns.ColumnSelect)this.index.getColumns().where((Matcher)Column.index().is((Comparable)Integer.valueOf(this.columnIndex))).select()).first();
    }

    public ActionBuilder with(Rule rule) {
        this.rule = rule;
        return this;
    }

    public ActionBuilder with(List<DTCellValue52> row) {
        this.row = row;
        return this;
    }

    public ActionBuilder with(ActionCol52 actionCol) {
        this.actionCol = actionCol;
        return this;
    }

    public ActionBuilder with(int columnIndex) {
        this.columnIndex = columnIndex;
        return this;
    }
}

