/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.OperatorsOracle;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.uberfire.commons.validation.PortablePreconditions;

public abstract class ColumnUtilitiesBase {
    private final GuidedDecisionTable52 model;

    public ColumnUtilitiesBase(GuidedDecisionTable52 model) {
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
    }

    public String getType(BaseColumn col) {
        if (col instanceof RowNumberCol52) {
            return this.getType((RowNumberCol52)col);
        }
        if (col instanceof AttributeCol52) {
            return this.getType((AttributeCol52)col);
        }
        if (col instanceof BRLConditionVariableColumn) {
            return this.getType((BRLConditionVariableColumn)col);
        }
        if (col instanceof ConditionCol52) {
            return this.getType((ConditionCol52)col);
        }
        if (col instanceof ActionSetFieldCol52) {
            return this.getType((ActionSetFieldCol52)col);
        }
        if (col instanceof ActionInsertFactCol52) {
            return this.getType((ActionInsertFactCol52)col);
        }
        if (col instanceof BRLActionVariableColumn) {
            return this.getType((BRLActionVariableColumn)col);
        }
        return "String";
    }

    private String getType(RowNumberCol52 col) {
        return "Integer";
    }

    private String getType(AttributeCol52 col) {
        String type = "String";
        String attrName = col.getAttribute();
        if (attrName.equals("salience")) {
            type = "Integer";
        } else if (attrName.equals("enabled")) {
            type = "Boolean";
        } else if (attrName.equals("no-loop")) {
            type = "Boolean";
        } else if (attrName.equals("duration")) {
            type = "Long";
        } else if (attrName.equals("timer")) {
            type = "String";
        } else if (attrName.equals("calendars")) {
            type = "String";
        } else if (attrName.equals("auto-focus")) {
            type = "Boolean";
        } else if (attrName.equals("lock-on-active")) {
            type = "Boolean";
        } else if (attrName.equals("date-effective")) {
            type = "Date";
        } else if (attrName.equals("date-expires")) {
            type = "Date";
        } else if (attrName.equals("dialect")) {
            type = "String";
        } else if (attrName.equals("negate")) {
            type = "Boolean";
        }
        return type;
    }

    private String getType(ConditionCol52 col) {
        Pattern52 pattern = this.model.getPattern(col);
        return this.getType(pattern, col);
    }

    protected String getType(Pattern52 pattern, ConditionCol52 col) {
        if (this.hasValueList(col)) {
            return "String";
        }
        if (OperatorsOracle.operatorRequiresList((String)col.getOperator())) {
            return "String";
        }
        if (col.getConstraintValueType() == 1 && (col.getOperator() == null || "".equals(col.getOperator()))) {
            return "String";
        }
        if (col.getConstraintValueType() == 5) {
            return "String";
        }
        if (col.getConstraintValueType() == 3) {
            return "String";
        }
        String factType = pattern.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromDataOracle(factType, fieldName);
    }

    private String getType(BRLConditionVariableColumn col) {
        if (col.getFactType() == null && col.getFactField() == null) {
            return col.getFieldType();
        }
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromDataOracle(factType, fieldName);
    }

    private String getType(ActionSetFieldCol52 col) {
        if (this.hasValueList(col)) {
            return "String";
        }
        String factType = this.getBoundFactType(col.getBoundName());
        String fieldName = col.getFactField();
        return this.getTypeFromDataOracle(factType, fieldName);
    }

    private String getType(Pattern52 pattern, ActionSetFieldCol52 col) {
        if (this.hasValueList(col)) {
            return "String";
        }
        String factType = pattern.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromDataOracle(factType, fieldName);
    }

    private String getType(ActionInsertFactCol52 col) {
        if (this.hasValueList(col)) {
            return "String";
        }
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromDataOracle(factType, fieldName);
    }

    private String getType(BRLActionVariableColumn col) {
        if (col.getFactType() == null && col.getFactField() == null) {
            return col.getFieldType();
        }
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromDataOracle(factType, fieldName);
    }

    protected abstract String getTypeFromDataOracle(String var1, String var2);

    public DataType.DataTypes getTypeSafeType(BaseColumn column) {
        String type = this.getType(column);
        return this.convertToTypeSafeType(type);
    }

    public DataType.DataTypes getTypeSafeType(Pattern52 pattern, ConditionCol52 column) {
        String type = this.getType(pattern, column);
        return this.convertToTypeSafeType(type);
    }

    public DataType.DataTypes getTypeSafeType(Pattern52 pattern, ActionSetFieldCol52 column) {
        String type = this.getType(pattern, column);
        return this.convertToTypeSafeType(type);
    }

    protected DataType.DataTypes convertToTypeSafeType(String type) {
        if ("Numeric".equals(type)) {
            return DataType.DataTypes.NUMERIC;
        }
        if ("BigDecimal".equals(type)) {
            return DataType.DataTypes.NUMERIC_BIGDECIMAL;
        }
        if ("BigInteger".equals(type)) {
            return DataType.DataTypes.NUMERIC_BIGINTEGER;
        }
        if ("Byte".equals(type)) {
            return DataType.DataTypes.NUMERIC_BYTE;
        }
        if ("Double".equals(type)) {
            return DataType.DataTypes.NUMERIC_DOUBLE;
        }
        if ("Float".equals(type)) {
            return DataType.DataTypes.NUMERIC_FLOAT;
        }
        if ("Integer".equals(type)) {
            return DataType.DataTypes.NUMERIC_INTEGER;
        }
        if ("Long".equals(type)) {
            return DataType.DataTypes.NUMERIC_LONG;
        }
        if ("Short".equals(type)) {
            return DataType.DataTypes.NUMERIC_SHORT;
        }
        if ("Boolean".equals(type)) {
            return DataType.DataTypes.BOOLEAN;
        }
        if ("Date".equals(type)) {
            return DataType.DataTypes.DATE;
        }
        return DataType.DataTypes.STRING;
    }

    public boolean hasValueList(AttributeCol52 col) {
        return "no-loop".equals(col.getAttribute()) || "enabled".equals(col.getAttribute());
    }

    public boolean hasValueList(ConditionCol52 col) {
        return col.getValueList() != null && !"".equals(col.getValueList());
    }

    public boolean hasValueList(ActionSetFieldCol52 col) {
        return col.getValueList() != null && !"".equals(col.getValueList());
    }

    public boolean hasValueList(ActionInsertFactCol52 col) {
        return col.getValueList() != null && !"".equals(col.getValueList());
    }

    public boolean isConstraintValid(DTColumnConfig52 col) {
        if (col instanceof RowNumberCol52) {
            return true;
        }
        if (col instanceof DescriptionCol52) {
            return true;
        }
        if (col instanceof MetadataCol52) {
            return true;
        }
        if (col instanceof AttributeCol52) {
            return true;
        }
        if (col instanceof ConditionCol52) {
            ConditionCol52 c = (ConditionCol52)col;
            if (c.getConstraintValueType() == 1) {
                if (c.getFactField() == null || c.getFactField().equals("")) {
                    return false;
                }
                return c.getOperator() != null && !c.getOperator().equals("");
            }
            return true;
        }
        return col instanceof ActionCol52;
    }

    public String getBoundFactType(String boundName) {
        for (CompositeColumn cc : this.model.getConditions()) {
            if (cc instanceof Pattern52) {
                Pattern52 p = (Pattern52)cc;
                if (!p.isBound() || !p.getBoundName().equals(boundName)) continue;
                return p.getFactType();
            }
            if (!(cc instanceof BRLConditionColumn)) continue;
            BRLConditionColumn brl = (BRLConditionColumn)cc;
            for (IPattern p : brl.getDefinition()) {
                FactPattern fp;
                if (!(p instanceof FactPattern) || !(fp = (FactPattern)p).isBound() || !fp.getBoundName().equals(boundName)) continue;
                return fp.getFactType();
            }
        }
        return "";
    }

    public boolean hasDSLSentences() {
        BRLConditionColumn brlColumn;
        for (CompositeColumn column : this.model.getConditions()) {
            if (!(column instanceof BRLConditionColumn)) continue;
            brlColumn = (BRLConditionColumn)column;
            for (IPattern pattern : brlColumn.getDefinition()) {
                if (!(pattern instanceof DSLSentence)) continue;
                return true;
            }
        }
        for (CompositeColumn column : this.model.getActionCols()) {
            if (!(column instanceof BRLActionColumn)) continue;
            brlColumn = (BRLActionColumn)column;
            for (IAction action : brlColumn.getDefinition()) {
                if (!(action instanceof DSLSentence)) continue;
                return true;
            }
        }
        return false;
    }

    public DataType.DataTypes getDataType(BaseColumn column) {
        ConditionCol52 cc;
        if (column instanceof LimitedEntryCol) {
            return DataType.DataTypes.BOOLEAN;
        }
        if (column instanceof ActionWorkItemCol52) {
            return DataType.DataTypes.BOOLEAN;
        }
        if (column instanceof ActionWorkItemSetFieldCol52 || column instanceof ActionWorkItemInsertFactCol52) {
            return DataType.DataTypes.BOOLEAN;
        }
        if (column instanceof ConditionCol52 && (cc = (ConditionCol52)column).getOperator() != null && (cc.getOperator().equals("== null") || cc.getOperator().equals("!= null"))) {
            return DataType.DataTypes.BOOLEAN;
        }
        return this.getTypeSafeType(column);
    }

    public DataType.DataTypes getDataType(Pattern52 pattern, ConditionCol52 condition) {
        if (condition instanceof LimitedEntryCol) {
            return DataType.DataTypes.BOOLEAN;
        }
        if (condition.getOperator() != null && (condition.getOperator().equals("== null") || condition.getOperator().equals("!= null"))) {
            return DataType.DataTypes.BOOLEAN;
        }
        return this.getTypeSafeType(pattern, condition);
    }

    public DataType.DataTypes getDataType(Pattern52 pattern, ActionSetFieldCol52 action) {
        if (action instanceof LimitedEntryCol) {
            return DataType.DataTypes.BOOLEAN;
        }
        return this.getTypeSafeType(pattern, action);
    }
}

