/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.services.verifier.api.client.checks.util.NullEqualityOperator;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Column;
import org.drools.workbench.services.verifier.api.client.index.Columns;
import org.drools.workbench.services.verifier.api.client.index.Condition;
import org.drools.workbench.services.verifier.api.client.index.Field;
import org.drools.workbench.services.verifier.api.client.index.FieldCondition;
import org.drools.workbench.services.verifier.api.client.index.Index;
import org.drools.workbench.services.verifier.api.client.index.Pattern;
import org.drools.workbench.services.verifier.api.client.index.keys.Values;
import org.drools.workbench.services.verifier.api.client.index.matchers.Matcher;
import org.drools.workbench.services.verifier.plugin.client.builders.BuildException;
import org.drools.workbench.services.verifier.plugin.client.builders.BuilderFactory;
import org.drools.workbench.services.verifier.plugin.client.builders.ToString;
import org.drools.workbench.services.verifier.plugin.client.builders.ValuesResolver;
import org.drools.workbench.services.verifier.plugin.client.builders.VerifierColumnUtilities;
import org.uberfire.commons.validation.PortablePreconditions;

public class FieldConditionBuilder {
    private final BuilderFactory builderFactory;
    private final Index index;
    private final VerifierColumnUtilities utils;
    private final AnalyzerConfiguration configuration;
    private Pattern pattern;
    private ConditionCol52 conditionCol52;
    private DTCellValue52 realCellValue;
    private int columnIndex;

    public FieldConditionBuilder(BuilderFactory builderFactory, Index index, VerifierColumnUtilities utils, AnalyzerConfiguration configuration) {
        this.builderFactory = (BuilderFactory)PortablePreconditions.checkNotNull((String)"builderFactory", (Object)builderFactory);
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.utils = (VerifierColumnUtilities)PortablePreconditions.checkNotNull((String)"utils", (Object)utils);
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
    }

    public Condition build() throws BuildException {
        PortablePreconditions.checkNotNull((String)"conditionCol52", (Object)this.conditionCol52);
        PortablePreconditions.checkNotNull((String)"columnIndex", (Object)this.columnIndex);
        try {
            Field field = this.resolveField();
            Condition condition = this.buildCondition(field);
            field.getConditions().add(condition);
            return condition;
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception e) {
            throw new BuildException("Failed to build " + this.pattern.getName() + " # " + ToString.toString(this.conditionCol52));
        }
    }

    private Field resolveField() throws BuildException {
        try {
            return this.builderFactory.getFieldResolver().with(this.pattern).with(this.columnIndex).with((BaseColumn)this.conditionCol52).resolve();
        }
        catch (Exception e) {
            throw new BuildException("Failed to resolve field " + this.pattern.getName() + " # " + ToString.toString(this.conditionCol52));
        }
    }

    private Condition buildCondition(Field field) throws BuildException {
        try {
            Column column = this.getColumn();
            return new FieldCondition(field, column, this.resolveOperator(this.conditionCol52.getOperator()), this.resolveValues(this.conditionCol52.getOperator()), this.configuration);
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException("Failed to build FieldCondition ");
        }
    }

    private Values resolveValues(String operator) throws BuildException {
        if (NullEqualityOperator.contains((String)operator)) {
            if (this.realCellValue.getBooleanValue() != null && this.realCellValue.getBooleanValue().booleanValue()) {
                return Values.nullValue();
            }
            return new Values();
        }
        try {
            Values values = new ValuesResolver(this.utils, this.columnIndex, this.conditionCol52, this.realCellValue).getValues();
            return values;
        }
        catch (Exception e) {
            throw new BuildException("Failed to resolve values:" + ToString.toString(this.conditionCol52) + " " + ToString.toString(this.realCellValue) + e.getMessage());
        }
    }

    private String resolveOperator(String operator) {
        if (NullEqualityOperator.contains((String)operator)) {
            return NullEqualityOperator.resolveOperator((String)operator);
        }
        return operator;
    }

    private Column getColumn() throws BuildException {
        try {
            return (Column)((Columns.ColumnSelect)this.index.getColumns().where((Matcher)Column.index().is((Comparable)Integer.valueOf(this.columnIndex))).select()).first();
        }
        catch (Exception e) {
            throw new BuildException("Failed to find column ");
        }
    }

    public FieldConditionBuilder with(Pattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public FieldConditionBuilder with(ConditionCol52 conditionCol52) {
        this.conditionCol52 = (ConditionCol52)PortablePreconditions.checkNotNull((String)"conditionCol52", (Object)conditionCol52);
        return this;
    }

    public FieldConditionBuilder with(DTCellValue52 realCellValue) {
        this.realCellValue = realCellValue;
        return this;
    }

    public FieldConditionBuilder with(int columnIndex) {
        this.columnIndex = columnIndex;
        return this;
    }
}

