/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.plugin.client.testutil.AnalyzerConfigurationMock;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerUniqueHitPolicyTest
extends AnalyzerUpdateTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.analyzerProvider.setConfiguration(new AnalyzerConfigurationMock(GuidedDecisionTable52.HitPolicy.UNIQUE_HIT));
    }

    @Test
    public void testUniqueHitPolicyRedundantRows() throws Exception {
        this.analyze("uniqueHitPolicyRedundantRows.gdst");
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.ERROR, 1, 2);
    }

    @Test
    public void testUniqueHitPolicySubsumptantRows() throws Exception {
        this.analyze("uniqueHitPolicySubsumptantRows.gdst");
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, Severity.ERROR, 1, 2);
    }

    @Test
    public void testUniqueHitPolicyRedundantAndSubsumptantRows() throws Exception {
        this.analyze("uniqueHitPolicyRedundantAndSubsumptantRows.gdst");
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, Severity.ERROR, 1, 2);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, Severity.ERROR, 2, 3);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.ERROR, 1, 3);
    }
}

