/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashSet;
import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.core.main.Analyzer;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.plugin.client.api.FactTypes;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class RangeCheckFromFileTest
extends AnalyzerUpdateTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.analyzerProvider.getFactTypes().add(new FactTypes.FactType("Employee", (Set)new HashSet<FactTypes.Field>(){
            {
                this.add(new FactTypes.Field("age", "Integer"));
                this.add(new FactTypes.Field("yearsService", "Integer"));
                this.add(new FactTypes.Field("vacationEntitlement", "Integer"));
            }
        }));
    }

    @Test
    @Ignore(value="list of admitted values is in the model and currently not accessible for the analyzer")
    public void testFileExtraDays() throws Exception {
        String xml = TestUtil.loadResource("Extra 5 days.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE);
    }
}

