/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;
import org.drools.workbench.services.verifier.plugin.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.plugin.client.testutil.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.Import;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerDeficiencyTest
extends AnalyzerUpdateTestBase {
    @Test
    public void testRuleIsNotDeficient() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withStringColumn("a", "Person", "name", "==").withStringColumn("a", "Person", "lastName", "==").withActionSetField("a", "salary", "Integer").withData(new Object[][]{{1, "", "description", null, "Eder", null, 100}, {2, "", "description", 10, null, null, 100}, {3, "", "description", null, "Toni", "Rikkola", 100}, {4, "", "description", null, null, null, null}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRuleIsDeficient001() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withStringColumn("a", "Person", "name", "==").withStringColumn("a", "Person", "lastName", "==").withActionSetField("a", "salary", "Integer").withData(new Object[][]{{1, "", "description", null, "Eder", null, 100}, {2, "", "description", 10, null, null, 200}, {3, "", "description", null, "Toni", "Rikkola", 300}, {4, "", "description", null, null, null, null}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.DEFICIENT_ROW, Severity.WARNING, 2);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 3);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 4);
    }

    @Test
    public void testRuleIsDeficient002() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withStringColumn("a", "Person", "name", "==").withStringColumn("a", "Person", "lastName", "==").withActionSetField("a", "salary", "Integer").withActionSetField("a", "description", "String").withData(new Object[][]{{1, "", "description", 10, "", "", 100, "ok"}, {2, "", "description", null, "", "", 200, "ok"}, {3, "", "description", 12, "", "Rikkola", 300, "ok"}, {4, "", "description", null, "", "", null, ""}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 2);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 3);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 4);
        this.setValue(1, 4, "Toni");
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.DEFICIENT_ROW, Severity.WARNING, 2);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 3);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 4);
    }

    @Test
    public void testRuleIsDeficient003() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withStringColumn("a", "Person", "name", "==").withStringColumn("a", "Person", "lastName", "==").withActionSetField("a", "salary", "Integer").withActionSetField("a", "description", "String").withData(new Object[][]{{1, "", "description", 10, "", "", 100, "ok"}, {2, "", "description", null, "Eder", "", 200, "ok"}, {3, "", "description", 12, "", "Rikkola", 300, "ok"}, {4, "", "description", null, "", "", null, ""}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.DEFICIENT_ROW, Severity.WARNING, 2);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 3);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 4);
        this.setValue(2, 4, "Toni");
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 2);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 3);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 4);
    }

    @Test
    public void testRuleIsDeficient004() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withStringColumn("a", "Person", "name", "==").withStringColumn("a", "Person", "lastName", "==").withActionSetField("a", "salary", "Integer").withActionSetField("a", "description", "String").withData(new Object[][]{{1, "", "description", 10, "", "", 100, "ok"}, {2, "", "description", null, "Eder", "", 200, "ok"}, {3, "", "description", 12, "Toni", "Rikkola", 300, "ok"}, {4, "", "description", null, "", "", null, ""}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 2);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 3);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 4);
        this.setValue(2, 4, "");
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.DEFICIENT_ROW, Severity.WARNING, 2);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 3);
        TestUtil.assertDoesNotContain(CheckType.DEFICIENT_ROW, this.analyzerProvider.getAnalysisReport(), 4);
    }
}

