/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.workbench.services.verifier.plugin.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.plugin.client.DataBuilderProvider;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.DataType;

@RunWith(value=GwtMockitoTestRunner.class)
public class NoOperatorTest
extends AnalyzerUpdateTestBase {
    @Test
    public void detectCellOperators() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withNoOperatorConditionIntegerColumn("a", "Person", "age").withNoOperatorConditionIntegerColumn("a", "Person", "age").withPersonApprovedActionSetField().withData(DataBuilderProvider.row("< 0", ">= 10", true).row(">= 20", ">= 20", true).end()).buildTable();
        this.fireUpAnalyzer();
        Set<Issue> analysisReport = this.analyzerProvider.getAnalysisReport();
        TestUtil.assertContains(analysisReport, CheckType.IMPOSSIBLE_MATCH, Severity.ERROR, 1);
        TestUtil.assertDoesNotContain(CheckType.IMPOSSIBLE_MATCH, analysisReport, 2);
        TestUtil.assertContains(analysisReport, CheckType.REDUNDANT_CONDITIONS_TITLE, Severity.NOTE, 2);
    }

    @Test
    public void detectCellOperatorsOnUpdate() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withNoOperatorConditionIntegerColumn("a", "Person", "age").withNoOperatorConditionIntegerColumn("a", "Person", "age").withPersonApprovedActionSetField().buildTable();
        this.fireUpAnalyzer();
        this.appendRow(DataType.DataTypes.STRING, DataType.DataTypes.STRING, DataType.DataTypes.BOOLEAN);
        this.setCoordinate().row(0).column(3).toValue(">= 20");
        this.setCoordinate().row(0).column(4).toValue(">= 20");
        this.setCoordinate().row(0).column(5).toValue(Boolean.TRUE);
        Set<Issue> analysisReport = this.analyzerProvider.getAnalysisReport();
        TestUtil.assertDoesNotContain(CheckType.IMPOSSIBLE_MATCH, analysisReport);
        TestUtil.assertContains(analysisReport, CheckType.REDUNDANT_CONDITIONS_TITLE, Severity.NOTE, 1);
    }

    @Test
    public void testIntervalsDirectlyInCells() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withNoOperatorConditionIntegerColumn("a", "Person", "age").withNoOperatorConditionIntegerColumn("a", "Person", "age").withPersonApprovedActionSetField().buildTable();
        this.fireUpAnalyzer();
        this.appendRow(DataType.DataTypes.STRING, DataType.DataTypes.STRING, DataType.DataTypes.BOOLEAN);
        this.setCoordinate().row(0).column(3).toValue(">= 20");
        this.setCoordinate().row(0).column(4).toValue("<= 30");
        this.setCoordinate().row(0).column(5).toValue(Boolean.TRUE);
        Set<Issue> analysisReport = this.analyzerProvider.getAnalysisReport();
        TestUtil.assertResultIsEmpty(analysisReport);
        this.appendRow(DataType.DataTypes.STRING, DataType.DataTypes.STRING, DataType.DataTypes.BOOLEAN);
        this.setCoordinate().row(1).column(3).toValue("< 20");
        this.setCoordinate().row(1).column(5).toValue(Boolean.TRUE);
        analysisReport = this.analyzerProvider.getAnalysisReport();
        TestUtil.assertResultIsEmpty(analysisReport);
        this.appendRow(DataType.DataTypes.STRING, DataType.DataTypes.STRING, DataType.DataTypes.BOOLEAN);
        this.setCoordinate().row(2).column(4).toValue("< 20");
        this.setCoordinate().row(2).column(5).toValue(Boolean.FALSE);
        analysisReport = this.analyzerProvider.getAnalysisReport();
        TestUtil.assertContains(analysisReport, CheckType.CONFLICTING_ROWS, Severity.WARNING, 2, 3);
    }
}

