/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;
import org.drools.workbench.services.verifier.plugin.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.plugin.client.DataBuilderProvider;
import org.drools.workbench.services.verifier.plugin.client.testutil.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.Import;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="https://issues.jboss.org/browse/DROOLS-2485 - randomly failing test. Also it's performance test (runs 110-180s on jenkins) - shouldn't run as part of daily builds")
@RunWith(value=GwtMockitoTestRunner.class)
public class SpeedTest
extends AnalyzerUpdateTestBase {
    Logger logger = LoggerFactory.getLogger(SpeedTest.class);

    @Test
    public void subsumptionTable() throws Exception {
        long baseline = System.currentTimeMillis();
        DataBuilderProvider.DataBuilder builder = DataBuilderProvider.row(true, null, true);
        for (int i = 0; i < 100; ++i) {
            builder.row(null, false, true);
        }
        Object[][] data = builder.end();
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionBooleanColumn("$p", "Person", "approved", "==").withConditionBooleanColumn("$p", "Person", "approved", "!=").withActionSetField("$p", "approved", "Boolean").withData(data).buildTable();
        long now = System.currentTimeMillis();
        this.logger.debug("Loading of model took.. " + (now - baseline) + " ms");
        baseline = now;
        this.fireUpAnalyzer();
        now = System.currentTimeMillis();
        this.logger.debug("Analyzing took.. " + (now - baseline) + " ms");
        baseline = now;
        this.setValue(1, 2, false);
        now = System.currentTimeMillis();
        this.logger.debug("Update.. " + (now - baseline) + " ms");
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, new Integer[0]);
    }

    @Test
    public void noConflictTable() throws Exception {
        long baseline = System.currentTimeMillis();
        DataBuilderProvider.DataBuilder builder = DataBuilderProvider.row(-1, true);
        for (int i = 0; i < 1000; ++i) {
            builder.row(i, true);
        }
        Object[][] data = builder.end();
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("$p", "Person", "age", "==").withActionSetField("$p", "approved", "Boolean").withData(data).buildTable();
        long now = System.currentTimeMillis();
        this.logger.debug("Loading of model took.. " + (now - baseline) + " ms");
        baseline = now;
        this.fireUpAnalyzer();
        now = System.currentTimeMillis();
        this.logger.debug("Analyzing took.. " + (now - baseline) + " ms");
        baseline = now;
        this.setValue(1, 2, 3);
        now = System.currentTimeMillis();
        this.logger.debug("Update.. " + (now - baseline) + " ms");
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, new Integer[0]);
    }
}

