/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.fromfile;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.main.Analyzer;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.plugin.client.Coordinate;
import org.drools.workbench.services.verifier.plugin.client.api.FactTypes;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Sets;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerFromFileTest
extends AnalyzerUpdateTestBase {
    @Test
    public void testUpdateNotNullColumn() throws Exception {
        String xml = TestUtil.loadResource("Is Null Table.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RESTRICTION, Severity.NOTE, new Integer[0]);
        ((DTCellValue52)((List)table52.getData().get(0)).get(3)).setBooleanValue(Boolean.valueOf(true));
        ArrayList<Coordinate> updates = new ArrayList<Coordinate>();
        updates.add(new Coordinate(0, 3));
        this.analyzerProvider.getUpdateManager(table52, analyzer).update(table52, updates);
        ((DTCellValue52)((List)table52.getData().get(1)).get(3)).setBooleanValue(Boolean.valueOf(true));
        ArrayList<Coordinate> updates2 = new ArrayList<Coordinate>();
        updates2.add(new Coordinate(1, 3));
        this.analyzerProvider.getUpdateManager(table52, analyzer).update(table52, updates2);
        TestUtil.assertDoesNotContain(CheckType.MISSING_RESTRICTION, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    @Ignore(value="list of admitted values is in the model and currently not accessible for the analyzer")
    public void testFilePricingLoansGDST() throws Exception {
        String xml = TestUtil.loadResource("Pricing loans.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE);
    }

    @Test
    public void testFileLargeFileGDST() throws Exception {
        String xml = TestUtil.loadResource("Large file.gdst");
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(GuidedDTXMLPersistence.getInstance().unmarshal(xml));
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.SINGLE_HIT_LOST, CheckType.EMPTY_RULE);
    }

    @Test
    public void emptyValueListOnColumnShouldNotCountAsAnEnum() throws Exception {
        this.analyzerProvider.getFactTypes().add(new FactTypes.FactType("Data", new Sets.Builder().add((Object)new FactTypes.Field("totalAmount", "Float")).build()));
        String xml = TestUtil.loadResource("DROOLS-5059.gdst");
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(GuidedDTXMLPersistence.getInstance().unmarshal(xml));
        analyzer.resetChecks();
        analyzer.analyze();
        Set<Issue> analysisReport = this.analyzerProvider.getAnalysisReport();
        TestUtil.assertOnlyContains(analysisReport, CheckType.MISSING_RANGE);
    }

    @Test
    @Ignore
    public void testFile3() throws Exception {
        String xml = TestUtil.loadResource("Pricing loans version 2.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertDoesNotContain(CheckType.REDUNDANT_ROWS, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testLHSConflictsArePickedUpForEachFieldOfAPattern() throws Exception {
        String xml = TestUtil.loadResource("GUVNOR-3513.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertResultIsEmpty(this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testLHSConflictsArePickedUpForEachFieldOfAPatternTheFileFromTicket() throws Exception {
        String xml = TestUtil.loadResource("GUVNOR-3513-second-version.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertResultIsEmpty(this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testFileScoreAchievementsGDST() throws Exception {
        this.analyzerProvider.getFactTypes().add(new FactTypes.FactType("Player", new Sets.Builder().add((Object)new FactTypes.Field("score", "Integer")).build()));
        String xml = TestUtil.loadResource("Score Achievements.gdst");
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(GuidedDTXMLPersistence.getInstance().unmarshal(xml));
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, CheckType.SINGLE_HIT_LOST);
    }

    @Test
    public void testFileBaseEntitlementGDST() throws Exception {
        String xml = TestUtil.loadResource("Base entitlement.gdst");
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(GuidedDTXMLPersistence.getInstance().unmarshal(xml));
        analyzer.resetChecks();
        analyzer.analyze();
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().isEmpty());
    }

    @Test
    public void testFileLargeFileGDSTWithUpdate() throws Exception {
        long baseline = System.currentTimeMillis();
        String xml = TestUtil.loadResource("Large file.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        long now = System.currentTimeMillis();
        System.out.println("Loading of model took.. " + (now - baseline) + " ms");
        baseline = now;
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        now = System.currentTimeMillis();
        System.out.println("Indexing took.. " + (now - baseline) + " ms");
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.SINGLE_HIT_LOST, CheckType.EMPTY_RULE);
        now = System.currentTimeMillis();
        System.out.println("Initial analysis took.. " + (now - baseline) + " ms");
        baseline = now;
        ((DTCellValue52)((List)table52.getData().get(2)).get(6)).clearValues();
        ArrayList<Coordinate> updates = new ArrayList<Coordinate>();
        updates.add(new Coordinate(2, 6));
        this.analyzerProvider.getUpdateManager(table52, analyzer).update(table52, updates);
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.SINGLE_HIT_LOST, CheckType.EMPTY_RULE);
        now = System.currentTimeMillis();
        System.out.println("Partial analysis took.. " + (now - baseline) + " ms");
    }

    @Test
    public void testFileLargeFileGDSTWithDeletes() throws Exception {
        String xml = TestUtil.loadResource("Large file.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.SINGLE_HIT_LOST, CheckType.EMPTY_RULE);
        long baseline = System.currentTimeMillis();
        for (int iterations = 0; iterations < 10; ++iterations) {
            analyzer.removeRule(Integer.valueOf(100));
            table52.getData().remove(100);
            ArrayList<Coordinate> canBeUpdated = new ArrayList<Coordinate>();
            canBeUpdated.add(new Coordinate(0, 0));
            this.analyzerProvider.getUpdateManager(table52, analyzer).update(table52, canBeUpdated);
            long now = System.currentTimeMillis();
            System.out.println("Partial analysis took.. " + (now - baseline) + " ms");
            baseline = now;
            TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.SINGLE_HIT_LOST, CheckType.EMPTY_RULE);
        }
    }
}

