/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.core.configuration.CheckConfiguration;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.CheckConfigurationProvider;
import org.junit.Assert;
import org.junit.Test;

public class CheckConfigurationProviderTest {
    private CheckConfiguration checkConfiguration;

    @Test
    public void getResolvedHitConfiguration() throws Exception {
        this.whenDecisionTableHas(GuidedDecisionTable52.HitPolicy.RESOLVED_HIT);
        this.thenTheFollowingCheckTypesAreNotIncluded(CheckType.getRowLevelCheckTypes());
    }

    @Test
    public void getRuleOrderConfiguration() throws Exception {
        this.whenDecisionTableHas(GuidedDecisionTable52.HitPolicy.RULE_ORDER);
        this.thenTheFollowingCheckTypesAreNotIncluded(CheckType.getRowLevelCheckTypes());
    }

    @Test
    public void getFirstHitConfiguration() throws Exception {
        this.whenDecisionTableHas(GuidedDecisionTable52.HitPolicy.FIRST_HIT);
        this.thenTheFollowingCheckTypesAreNotIncluded(CheckType.getRowLevelCheckTypes());
    }

    @Test
    public void getNoHitPolicySetConfiguration() throws Exception {
        this.whenDecisionTableHas(GuidedDecisionTable52.HitPolicy.NONE);
        this.thenAllOfTheFollowingChecksAreIncluded(CheckConfiguration.newDefault().getCheckConfiguration());
    }

    @Test
    public void getSetConfiguration() throws Exception {
        this.whenDecisionTableHas(GuidedDecisionTable52.HitPolicy.UNIQUE_HIT);
        this.thenAllOfTheFollowingChecksAreIncluded(CheckConfiguration.newDefault().getCheckConfiguration());
    }

    private void thenAllOfTheFollowingChecksAreIncluded(Set<CheckType> checkTypes) {
        for (CheckType checkType : checkTypes) {
            Assert.assertTrue((boolean)this.checkConfiguration.getCheckConfiguration().contains(checkType));
        }
    }

    private void thenTheFollowingCheckTypesAreNotIncluded(Set<CheckType> checkTypes) {
        for (CheckType checkType : checkTypes) {
            Assert.assertFalse((boolean)this.checkConfiguration.getCheckConfiguration().contains(checkType));
        }
    }

    private void whenDecisionTableHas(GuidedDecisionTable52.HitPolicy hitPolicy) {
        this.checkConfiguration = CheckConfigurationProvider.get((GuidedDecisionTable52.HitPolicy)hitPolicy);
    }
}

