/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.workbench.services.verifier.plugin.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.plugin.client.DataBuilderProvider;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.DataType;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerRedundancyTest
extends AnalyzerUpdateTestBase {
    @Test
    public void twoNewRulesShouldNotBeRedundant() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().conditionColumn().person("aa").age(">").actionColumn().retract().withData(DataBuilderProvider.row(22, "aa").end()).buildTable();
        this.fireUpAnalyzer();
        this.appendRow(DataType.DataTypes.NUMERIC_INTEGER, DataType.DataTypes.STRING);
        TestUtil.assertDoesNotContain(CheckType.REDUNDANT_ROWS, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void twoNewRulesShouldNotBeRedundantScenario() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().conditionColumn().person("aa").age(">").actionColumn().retract().buildTable();
        this.fireUpAnalyzer();
        this.appendRow(DataType.DataTypes.NUMERIC_INTEGER, DataType.DataTypes.STRING);
        this.setCoordinate().row(0).column(2).toValue(22);
        this.setCoordinate().row(0).column(3).toValue("aa");
        this.appendRow(DataType.DataTypes.NUMERIC_INTEGER, DataType.DataTypes.STRING);
        TestUtil.assertDoesNotContain(CheckType.REDUNDANT_ROWS, this.analyzerProvider.getAnalysisReport());
    }
}

