/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.Index;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.ObjectType;
import org.drools.verifier.core.index.model.ObjectTypes;
import org.drools.verifier.core.index.model.Pattern;
import org.drools.verifier.core.index.model.Patterns;
import org.drools.verifier.core.index.model.Rule;
import org.drools.workbench.services.verifier.plugin.client.api.HeaderMetaData;
import org.kie.soup.commons.validation.PortablePreconditions;

public class PatternResolver {
    private final Index index;
    private final AnalyzerConfiguration configuration;
    private final HeaderMetaData headerMetaData;
    private Rule rule;
    private int columnIndex;

    public PatternResolver(Index index, HeaderMetaData headerMetaData, AnalyzerConfiguration configuration) {
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.headerMetaData = (HeaderMetaData)PortablePreconditions.checkNotNull((String)"headerMetaData", (Object)headerMetaData);
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
    }

    private ObjectType resolveObjectType(String factType) {
        ObjectType first = (ObjectType)((ObjectTypes.ObjectTypesSelect)this.index.getObjectTypes().where((Matcher)ObjectType.type().is((Comparable)((Object)factType))).select()).first();
        if (first == null) {
            ObjectType objectType = new ObjectType(factType, this.configuration);
            this.index.getObjectTypes().add(new ObjectType[]{objectType});
            return objectType;
        }
        return first;
    }

    public Pattern resolve() {
        PortablePreconditions.checkNotNull((String)"rule", (Object)this.rule);
        Pattern pattern = (Pattern)((Patterns.PatternsSelect)this.rule.getPatterns().where((Matcher)Pattern.boundName().is((Comparable)((Object)this.getBoundName()))).select()).first();
        if (pattern == null) {
            Pattern build = new Pattern(this.getBoundName(), this.resolveObjectType(this.getFactType()), this.configuration);
            this.rule.getPatterns().add(new Pattern[]{build});
            return build;
        }
        return pattern;
    }

    private String getFactType() {
        String factType = this.headerMetaData.getPatternsByColumnNumber((Integer)PortablePreconditions.checkNotNull((String)"columnIndex", (Object)this.columnIndex)).getFactType();
        return factType;
    }

    private String getBoundName() {
        String boundName = this.headerMetaData.getPatternsByColumnNumber((Integer)PortablePreconditions.checkNotNull((String)"columnIndex", (Object)this.columnIndex)).getBoundName();
        return boundName;
    }

    public PatternResolver with(Rule rule) {
        this.rule = rule;
        return this;
    }

    public PatternResolver with(int columnIndex) {
        this.columnIndex = columnIndex;
        return this;
    }
}

