/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.configuration.CheckConfiguration;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;

public class CheckConfigurationProvider {
    public static CheckConfiguration get(GuidedDecisionTable52.HitPolicy hitPolicy) {
        switch (hitPolicy) {
            case RULE_ORDER: 
            case FIRST_HIT: 
            case RESOLVED_HIT: {
                return CheckConfigurationProvider.getAllowListWithNoRowToRowChecks();
            }
            case UNIQUE_HIT: {
                return CheckConfigurationProvider.getUniqueHitPolicyChecks();
            }
        }
        return CheckConfiguration.newDefault();
    }

    private static CheckConfiguration getAllowListWithNoRowToRowChecks() {
        CheckConfiguration checkConfiguration = CheckConfiguration.newDefault();
        checkConfiguration.getCheckConfiguration().removeAll(CheckType.getRowLevelCheckTypes());
        return checkConfiguration;
    }

    private static CheckConfiguration getUniqueHitPolicyChecks() {
        CheckConfiguration checkConfiguration = CheckConfiguration.newDefault();
        checkConfiguration.setSeverityOverwrites(CheckType.REDUNDANT_ROWS, Severity.ERROR);
        checkConfiguration.setSeverityOverwrites(CheckType.SUBSUMPTANT_ROWS, Severity.ERROR);
        return checkConfiguration;
    }
}

