/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.webworker.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.services.verifier.webworker.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.webworker.client.DataBuilderProvider;
import org.drools.workbench.services.verifier.webworker.client.testutil.TestUtil;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerConflictResolverTest
extends AnalyzerUpdateTestBase {
    @Test
    public void testNoIssue() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonAgeColumn(">").withAccountDepositColumn("<").withApplicationApprovedSetField().withData(DataBuilderProvider.row(100, 0.0, true).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.CONFLICTING_ROWS, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testNoIssueWithNulls() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn(">").withPersonAgeColumn("<").withData(DataBuilderProvider.row(null, null).end()).buildTable();
        ((DTCellValue52)((List)this.table52.getData().get(0)).get(2)).setStringValue("");
        ((DTCellValue52)((List)this.table52.getData().get(0)).get(3)).setStringValue("");
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.EMPTY_RULE, Severity.WARNING, 1);
    }

    @Test
    public void testImpossibleMatch001() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonAgeColumn(">").withPersonAgeColumn("<").withData(DataBuilderProvider.row(100, 0).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.IMPOSSIBLE_MATCH, Severity.ERROR, new Integer[0]);
    }

    @Test
    public void testImpossibleMatch002() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withEnumColumn("a", "Person", "name", "==", "Toni,Eder").withPersonNameColumn("==").withData(DataBuilderProvider.row("Toni", "").end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.IMPOSSIBLE_MATCH, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testConflictIgnoreEmptyRows() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(null, "").row(null, "true").end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.CONFLICTING_ROWS, this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertDoesNotContain(CheckType.CONFLICTING_ROWS, this.analyzerProvider.getAnalysisReport(), 2);
    }

    @Test
    public void testConflictWithASubsumingRow() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonNameColumn("==").withPersonLastNameColumn("==").withPersonSalarySetFieldAction().withPersonDescriptionSetActionField().withData(DataBuilderProvider.row(null, null, null, 100, "ok").row(null, "Toni", null, 200, "ok").row(12, "Toni", "Rikkola", 300, "ok").row(null, null, null, null, null).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.CONFLICTING_ROWS, Severity.WARNING, 2);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.CONFLICTING_ROWS, Severity.WARNING, 3);
    }
}

