/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.webworker.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashSet;
import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;
import org.drools.workbench.services.verifier.plugin.client.api.FactTypes;
import org.drools.workbench.services.verifier.webworker.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.webworker.client.UpdateException;
import org.drools.workbench.services.verifier.webworker.client.testutil.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerMultipleIssuesFromFileTest
extends AnalyzerUpdateTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.analyzerProvider.getFactTypes().add(new FactTypes.FactType("LoanApplication", (Set)new HashSet<FactTypes.Field>(){
            {
                this.add(new FactTypes.Field("amount", "Integer"));
                this.add(new FactTypes.Field("lengthYears", "Integer"));
                this.add(new FactTypes.Field("approvedRate", "Integer"));
                this.add(new FactTypes.Field("explanation", "String"));
                this.add(new FactTypes.Field("approved", "Boolean"));
            }
        }));
    }

    @Test
    public void testMissingRangeAndRedundantRows() throws Exception, UpdateException {
        this.analyze("missingRangeAndRedundantRows.gdst");
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, CheckType.REDUNDANT_ROWS);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, Severity.NOTE, 1);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, Severity.NOTE, 2);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 1, 2);
    }

    @Test
    public void testMissingRangeAndSubsumptantRows() throws Exception {
        this.analyze("missingRangeAndSubsumptantRows.gdst");
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, CheckType.SUBSUMPTANT_ROWS);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, Severity.NOTE, 5);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, Severity.WARNING, 1, 6);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, Severity.WARNING, 2, 6);
    }

    @Test
    public void testMissingRangeAndConflictingRows() throws Exception {
        this.analyze("missingRangeAndConflictingRows.gdst");
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, CheckType.CONFLICTING_ROWS);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, Severity.NOTE, 5);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.CONFLICTING_ROWS, Severity.WARNING, 3, 6);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.CONFLICTING_ROWS, Severity.WARNING, 4, 6);
    }

    @Test
    public void testMissingRangeAndMissingColumns() throws Exception {
        this.analyze("missingRangeAndMissingColumns.gdst");
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, CheckType.MISSING_ACTION);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, Severity.NOTE, 5);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_ACTION, Severity.WARNING, 5);
    }

    @Test
    public void testSubsumptionAndRedundancy() throws Exception {
        this.analyze("subsumptionAndRedundancy.gdst");
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, CheckType.REDUNDANT_ROWS);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, Severity.WARNING, 1, 2);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, Severity.WARNING, 1, 3);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 2, 3);
    }

    @Test
    public void testSubsumptionAndRedundancyMultipleFields() throws Exception {
        this.analyze("subsumptionAndRedundancyMultipleFields.gdst");
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, Severity.WARNING, 1, 2);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, Severity.WARNING, 1, 3);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 2, 3);
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, CheckType.REDUNDANT_ROWS);
    }

    @Test
    public void testSubsumptionAndConflict() throws Exception {
        this.analyze("subsumptionAndConflict.gdst");
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, CheckType.CONFLICTING_ROWS);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, Severity.WARNING, 1, 2);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.CONFLICTING_ROWS, Severity.WARNING, 2, 4);
    }

    @Test
    public void testSubsumptionAndMissingAction() throws Exception {
        this.analyze("subsumptionAndMissingAction.gdst");
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, Severity.WARNING, 1, 2);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_ACTION, Severity.WARNING, 3);
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.SUBSUMPTANT_ROWS, CheckType.MISSING_ACTION);
    }

    @Test
    public void testRedundancyAndConflicts() throws Exception {
        this.analyze("redundancyAndConflicts.gdst");
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, CheckType.CONFLICTING_ROWS);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 1, 3);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.CONFLICTING_ROWS, Severity.WARNING, 2, 4);
    }

    @Test
    public void testRedundancyAndConflictsMultipleFields() throws Exception {
        this.analyze("redundancyAndConflictsMultipleFields.gdst");
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 1, 2);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.CONFLICTING_ROWS, Severity.WARNING, 1, 3);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.CONFLICTING_ROWS, Severity.WARNING, 2, 3);
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, CheckType.CONFLICTING_ROWS);
    }

    @Test
    public void testMissingConditionAndMissingAction() throws Exception {
        this.analyze("missingConditionAndMissingAction.gdst");
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RESTRICTION, CheckType.MISSING_ACTION, CheckType.SINGLE_HIT_LOST);
    }

    @Test
    public void testGapAnalysis() throws Exception {
        this.analyze("gapAnalysis.gdst");
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().isEmpty());
    }

    @Test
    public void testBidimensionalGapAnalysis() throws Exception {
        this.analyze("gapAnalysis2D.gdst");
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE);
    }

    @Test
    public void testBidimensionalGapAnalysisOK() throws Exception {
        this.analyze("gapAnalysis2DOK.gdst");
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().isEmpty());
    }
}

