/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.webworker.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;
import org.drools.workbench.services.verifier.webworker.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.webworker.client.DataBuilderProvider;
import org.drools.workbench.services.verifier.webworker.client.testutil.TestUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerRangeCheckTest
extends AnalyzerUpdateTestBase {
    @Test
    public void testMissingRangeNoIssueNameHasNoRange() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonNameColumn("==").withApplicationApprovedSetField().withData(DataBuilderProvider.row("Toni", true).row("Michael", true).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.MISSING_RANGE, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testMissingRangeNoIssue() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonApprovedColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(true, true).row(false, true).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.MISSING_RANGE, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    @Ignore(value="list of admitted values is in the model and currently not accessible for the analyzer")
    public void testMissingRangeMissingNotApprovedFromLHS() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonApprovedColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(true, true).row(true, false).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, Severity.NOTE, new Integer[0]);
    }

    @Test
    public void testMissingAgeBetween1And100() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("<").withPersonAgeColumn(">=").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(0, null, true).row(null, 100, false).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, Severity.NOTE, new Integer[0]);
    }

    @Test
    public void testCompleteAgeRange() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("<").withPersonAgeColumn(">=").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(0, null, true).row(null, 0, true).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.MISSING_RANGE, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testMissingDepositBetween0And12345() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withAccountDepositColumn("<").withAccountDepositColumn(">").withPersonApprovedActionInsertFact().withData(DataBuilderProvider.row(0.0, null, true).row(null, 12345.0, true).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, Severity.NOTE, new Integer[0]);
    }

    @Test
    public void testCompleteAccountRange() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withAccountDepositColumn(">=").withAccountDepositColumn("<").withPersonApprovedActionInsertFact().withData(DataBuilderProvider.row(0.0, null, true).row(null, 0.0, true).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.MISSING_RANGE, this.analyzerProvider.getAnalysisReport());
    }
}

