/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.webworker.client.cache.util;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.drools.verifier.core.main.Analyzer;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.Coordinate;
import org.drools.workbench.services.verifier.webworker.client.DTableUpdateManager;
import org.drools.workbench.services.verifier.webworker.client.DataBuilderProvider;
import org.drools.workbench.services.verifier.webworker.client.UpdateException;
import org.drools.workbench.services.verifier.webworker.client.testutil.AnalyzerProvider;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DTableUpdateManagerIsNullTest {
    private DTableUpdateManager updateManager;
    private GuidedDecisionTable52 table52;
    @Mock
    private Analyzer analyzer;
    private AnalyzerProvider analyzerProvider;

    @Before
    public void setUp() throws Exception {
        this.analyzerProvider = new AnalyzerProvider();
        this.table52 = this.analyzerProvider.makeAnalyser().withConditionBooleanColumn("a", "Person", "name", "== null").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(true, true).row(false, true).row(null, true).end()).buildTable();
        this.updateManager = this.analyzerProvider.getUpdateManager(this.table52, this.analyzer);
    }

    @Test
    public void testTrueDidNotChange() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(0, 2));
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer, (VerificationMode)Mockito.never())).update(Mockito.anySet());
    }

    @Test
    public void testFalseDidNotChange() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(1, 2));
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer, (VerificationMode)Mockito.never())).update(Mockito.anySet());
    }

    @Test
    public void testNullDidNotChange() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(2, 2));
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer, (VerificationMode)Mockito.never())).update(Mockito.anySet());
    }

    @Test
    public void testSetTrueToFalse() throws Exception, UpdateException {
        this.set(0, 2, false);
        ((Analyzer)Mockito.verify((Object)this.analyzer)).update(Mockito.anySet());
    }

    @Test
    public void testSetTrueToNull() throws Exception, UpdateException {
        this.set(0, 2, null);
        ((Analyzer)Mockito.verify((Object)this.analyzer)).update(Mockito.anySet());
    }

    @Test
    public void testSetFalseToTrue() throws Exception, UpdateException {
        this.set(1, 2, true);
        ((Analyzer)Mockito.verify((Object)this.analyzer)).update(Mockito.anySet());
    }

    @Test
    public void testSetFalseToNull() throws Exception, UpdateException {
        this.set(1, 2, null);
        ((Analyzer)Mockito.verify((Object)this.analyzer, (VerificationMode)Mockito.never())).update(Mockito.anySet());
    }

    @Test
    public void testSetNullToTrue() throws Exception, UpdateException {
        this.set(2, 2, true);
        ((Analyzer)Mockito.verify((Object)this.analyzer)).update(Mockito.anySet());
    }

    @Test
    public void testSetNullToFalse() throws Exception, UpdateException {
        this.set(2, 2, false);
        ((Analyzer)Mockito.verify((Object)this.analyzer, (VerificationMode)Mockito.never())).update(Mockito.anySet());
    }

    private void set(int row, int col, Boolean value) throws UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(row, col);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(row)).get(col)).setBooleanValue(value);
        this.updateManager.update(this.table52, coordinates);
    }
}

