/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.webworker.client.cache.util;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.verifier.core.main.Analyzer;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.Coordinate;
import org.drools.workbench.services.verifier.webworker.client.DTableUpdateManager;
import org.drools.workbench.services.verifier.webworker.client.DataBuilderProvider;
import org.drools.workbench.services.verifier.webworker.client.UpdateException;
import org.drools.workbench.services.verifier.webworker.client.testutil.AnalyzerProvider;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DTableUpdateManagerTest {
    private DTableUpdateManager updateManager;
    private GuidedDecisionTable52 table52;
    private AnalyzerProvider analyzerProvider;
    @Mock
    private Analyzer analyzer;

    @Before
    public void setUp() throws Exception {
        this.analyzerProvider = new AnalyzerProvider();
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, true).row(null, null).end()).buildTable();
        this.updateManager = this.analyzerProvider.getUpdateManager(this.table52, this.analyzer);
    }

    @Test
    public void testDoNotUpdateWhenDescriptionChanges() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(1, 1));
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer, (VerificationMode)Mockito.never())).update((Set)Matchers.any(Set.class));
    }

    @Test
    public void testDoNotUpdateConditionWhenValueDidNotChange() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(1, 2));
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer, (VerificationMode)Mockito.never())).update(Mockito.anySet());
    }

    @Test
    public void testDoNotUpdateActionWhenValueDidNotChange() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(0, 3));
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer, (VerificationMode)Mockito.never())).update(Mockito.anySet());
    }

    @Test
    public void testSetIntegerConditionToNewInteger() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(0, 2);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(0)).get(2)).setNumericValue(Integer.valueOf(123));
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer)).update(Mockito.anySet());
    }

    @Test
    public void testSetBooleanActionToNewBoolean() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(0, 3);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(0)).get(3)).setBooleanValue(Boolean.valueOf(false));
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer)).update(Mockito.anySet());
    }

    @Test
    public void testSetActionToNull() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(0, 3);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(0)).get(3)).setBooleanValue(null);
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer)).update(Mockito.anySet());
    }

    @Test
    public void testSetConditionToNull() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(0, 2);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(0)).get(2)).setNumericValue((Integer)null);
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer)).update(Mockito.anySet());
    }

    @Test
    public void testFillNullCondition() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(1, 2);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(1)).get(2)).setNumericValue(Integer.valueOf(123));
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer)).update(Mockito.anySet());
    }

    @Test
    public void testFillNullAction() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(1, 3);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(1)).get(3)).setBooleanValue(Boolean.valueOf(false));
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer)).update(Mockito.anySet());
    }

    @Test
    public void testFillNullActionWithNull() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(1, 3);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(1)).get(3)).setBooleanValue(null);
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer, (VerificationMode)Mockito.never())).update(Mockito.anySet());
    }

    @Test
    public void testFillNullConditionWithNull() throws Exception, UpdateException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(1, 2);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(1)).get(2)).setNumericValue((Integer)null);
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer, (VerificationMode)Mockito.never())).update(Mockito.anySet());
    }
}

