/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.webworker.client.testutil;

import java.util.HashSet;
import java.util.Set;
import org.drools.verifier.api.Status;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.main.Analyzer;
import org.drools.verifier.core.main.Reporter;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.api.FactTypes;
import org.drools.workbench.services.verifier.webworker.client.DTableUpdateManager;
import org.drools.workbench.services.verifier.webworker.client.testutil.AnalyzerBuilder;
import org.drools.workbench.services.verifier.webworker.client.testutil.AnalyzerConfigurationMock;
import org.drools.workbench.services.verifier.webworker.client.testutil.DecisionTableAnalyzerBuilder;

public class AnalyzerProvider {
    private Set<Issue> analysisReport;
    private Status status;
    private Analyzer analyzer = null;
    private AnalyzerConfiguration configuration = new AnalyzerConfigurationMock();
    private DTableUpdateManager updateManager;
    private FactTypes factTypes = new FactTypes();
    private DecisionTableAnalyzerBuilder decisionTableAnalyzerBuilder;

    public AnalyzerProvider() {
        this.factTypes.add(new FactTypes.FactType("Applicant", (Set)new HashSet<FactTypes.Field>(){
            {
                this.add(new FactTypes.Field("age", "Integer"));
            }
        }));
        this.factTypes.add(new FactTypes.FactType("Account", (Set)new HashSet<FactTypes.Field>(){
            {
                this.add(new FactTypes.Field("deposit", "Double"));
            }
        }));
        this.factTypes.add(new FactTypes.FactType("Person", (Set)new HashSet<FactTypes.Field>(){
            {
                this.add(new FactTypes.Field("age", "Integer"));
                this.add(new FactTypes.Field("name", "String"));
                this.add(new FactTypes.Field("lastName", "String"));
                this.add(new FactTypes.Field("description", "String"));
                this.add(new FactTypes.Field("approved", "Boolean"));
                this.add(new FactTypes.Field("salary", "Integer"));
            }
        }));
    }

    public FactTypes getFactTypes() {
        return this.factTypes;
    }

    public Set<Issue> getAnalysisReport() {
        return this.analysisReport;
    }

    public Status getStatus() {
        return this.status;
    }

    public Analyzer getAnalyser(GuidedDecisionTable52 table52) {
        DecisionTableAnalyzerBuilder builder = this.getDecisionTableAnalyzerBuilder().withFieldTypes(this.factTypes).withAnalyzer(this.analyzer).withModel(table52);
        return builder.build();
    }

    public DTableUpdateManager getUpdateManager(GuidedDecisionTable52 table52, Analyzer analyzer) {
        this.updateManager = this.getDecisionTableAnalyzerBuilder().withFieldTypes(this.factTypes).withModel(table52).withAnalyzer(analyzer).withConfiguration(this.configuration).getUpdateManagerBuilder().buildUpdateManager();
        return this.updateManager;
    }

    private DecisionTableAnalyzerBuilder getDecisionTableAnalyzerBuilder() {
        if (this.decisionTableAnalyzerBuilder == null) {
            this.decisionTableAnalyzerBuilder = new DecisionTableAnalyzerBuilder(){

                @Override
                protected DecisionTableAnalyzerBuilder.InnerBuilder getInnerBuilder() {
                    return new DecisionTableAnalyzerBuilder.InnerBuilder(AnalyzerProvider.this.configuration){

                        @Override
                        protected Reporter getAnalysisReporter() {
                            return AnalyzerProvider.this.getAnalysisReporter();
                        }
                    };
                }
            };
        }
        return this.decisionTableAnalyzerBuilder;
    }

    private Reporter getAnalysisReporter() {
        return new Reporter(){

            public void sendReport(Set<Issue> issues) {
                AnalyzerProvider.this.analysisReport = issues;
            }

            public void sendStatus(Status _status) {
                AnalyzerProvider.this.status = _status;
            }
        };
    }

    public AnalyzerBuilder makeAnalyser() {
        return new AnalyzerBuilder(this);
    }

    public Analyzer makeAnalyser(GuidedDecisionTable52 table52) {
        return this.getAnalyser(table52);
    }

    public void setConfiguration(AnalyzerConfiguration analyzerConfiguration) {
        this.configuration = analyzerConfiguration;
    }
}

