/*
 * Decompiled with CFR 0.152.
 */
package org.drools.dynamic;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.junit.Test;

public class ClassLoaderTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testParallelClassLoading() {
        int THREAD_COUNT = 100;
        ProjectClassLoader projectClassLoader = ProjectClassLoader.createProjectClassLoader();
        ClassLoader internalTypesClassLoader = (ClassLoader)projectClassLoader.makeClassLoader();
        projectClassLoader.setInternalClassLoader((ProjectClassLoader.InternalTypesClassLoader)internalTypesClassLoader);
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        try {
            int i;
            ArrayList futures = new ArrayList();
            for (i = 0; i < 100; ++i) {
                if (i % 2 == 0) {
                    futures.add(executorService.submit(() -> {
                        try {
                            Class.forName("nonexistant", true, (ClassLoader)projectClassLoader);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }));
                    continue;
                }
                futures.add(executorService.submit(() -> {
                    try {
                        Class.forName("nonexistant", true, internalTypesClassLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }));
            }
            for (i = 1; i <= 100; ++i) {
                try {
                    ((Future)futures.get(i - 1)).get();
                    continue;
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }
}

