/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.template.backend;

import org.drools.workbench.models.commons.backend.rule.RuleModelPersistence;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.ActionUpdateField;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.ConnectiveConstraint;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.template.backend.RuleTemplateModelDRLPersistenceImpl;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RuleTemplateModelDRLPersistenceTest {
    private RuleModelPersistence ruleModelPersistence;

    @Before
    public void setUp() throws Exception {
        this.ruleModelPersistence = RuleTemplateModelDRLPersistenceImpl.getInstance();
    }

    private void checkMarshall(String expected, RuleModel m) {
        String drl = this.ruleModelPersistence.marshal(m);
        Assert.assertNotNull((Object)drl);
        if (expected != null) {
            this.assertEqualsIgnoreWhitespace(expected, drl);
        }
    }

    @Test
    public void testInWithSimpleSingleLiteralValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("in");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{"ak1,mk1"});
        m.addRow(new String[]{"(ak2,mk2)"});
        m.addRow(new String[]{"( ak3, mk3 )"});
        m.addRow(new String[]{"( \"ak4\", \"mk4\" )"});
        m.addRow(new String[]{"( \"ak5 \", \" mk5\" )"});
        String expected = "rule \"t1_4\"dialect \"mvel\"\nwhen \n  Person( field1 in (\"ak5 \",\" mk5\") )then \nendrule \"t1_3\"dialect \"mvel\"\nwhen \n  Person( field1 in (\"ak4\",\"mk4\") )then \nendrule \"t1_2\"dialect \"mvel\"\nwhen \n  Person( field1 in (\"ak3\",\"mk3\") )then \nendrule \"t1_1\"dialect \"mvel\"\nwhen \n  Person( field1 in (\"ak2\",\"mk2\") )then \nendrule \"t1_0\"dialect \"mvel\"\nwhen \n  Person( field1 in (\"ak1\",\"mk1\") )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleSingleValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{"foo"});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field1 == \"foo\" )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testRHSInsert() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionInsertFact actionInsertFact = new ActionInsertFact();
        actionInsertFact.setFactType("Applicant");
        ActionFieldValue actionFieldValue = new ActionFieldValue("age", "123", "Integer");
        actionFieldValue.setNature(1);
        actionInsertFact.addFieldValue(actionFieldValue);
        m.addRhsItem((IAction)actionInsertFact);
        m.addRow(new String[]{"foo"});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field1 == \"foo\" )\nthen \n  Applicant fact0 = new Applicant(); \n  fact0.setAge(123); \n  insert(fact0); \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleSingleTemplateValueSingleLiteralValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con.setFieldType("String");
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("bar");
        con2.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{"foo"});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field1 == \"foo\", field2 == \"bar\" )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con.setFieldType("String");
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("$f2");
        con2.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{"foo", "bar"});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field1 == \"foo\", field2 == \"bar\" )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con.setFieldType("String");
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("$f2");
        con2.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{"foo", null});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field1 == \"foo\" )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con.setFieldType("String");
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("$f2");
        con2.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{null, "bar"});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field2 == \"bar\" )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testGeneratorFactoryReuse() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con.setFieldType("String");
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("$f2");
        con2.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{"foo", "bar"});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field1 == \"foo\", field2 == \"bar\" )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeConstraintsBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p1.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("field2");
        Y.setFieldType("String");
        Y.setConstraintValueType(7);
        Y.setValue("$f2");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || field2 == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeConstraintsFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p1.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("field2");
        Y.setFieldType("String");
        Y.setConstraintValueType(7);
        Y.setValue("$f2");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeConstraintsSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p1.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("field2");
        Y.setFieldType("String");
        Y.setConstraintValueType(7);
        Y.setValue("$f2");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field2 == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeConstraintWithConnectiveConstraintBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p1.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        comp.addConstraint((FieldConstraint)X);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(1);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("goo");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = connective;
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("field2");
        Y.setFieldType("String");
        Y.setConstraintValueType(7);
        Y.setValue("$f2");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || == \"goo\" || field2 == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeConstraintWithConnectiveConstraintFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p1.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        comp.addConstraint((FieldConstraint)X);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(1);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("goo");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = connective;
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("field2");
        Y.setFieldType("String");
        Y.setConstraintValueType(7);
        Y.setValue("$f2");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || == \"goo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeConstraintWithConnectiveConstraintSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p1.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        comp.addConstraint((FieldConstraint)X);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(1);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("goo");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = connective;
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("field2");
        Y.setFieldType("String");
        Y.setConstraintValueType(7);
        Y.setValue("$f2");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field2 == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeFactPatternBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        CompositeFactPattern cp = new CompositeFactPattern("or");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        p1.addConstraint((FieldConstraint)sfc1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        p2.addConstraint((FieldConstraint)sfc2);
        cp.addFactPattern((IFactPattern)p1);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\n(\nPerson( field1 == \"foo\" )\nor\nPerson( field2 == \"bar\" )\n)\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeFactPatternFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        CompositeFactPattern cp = new CompositeFactPattern("or");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        p1.addConstraint((FieldConstraint)sfc1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        p2.addConstraint((FieldConstraint)sfc2);
        cp.addFactPattern((IFactPattern)p1);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\n(\nPerson( field1 == \"foo\" )\nor\nPerson( )\n)\nthen\nend\n";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeFactPatternSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        CompositeFactPattern cp = new CompositeFactPattern("or");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        p1.addConstraint((FieldConstraint)sfc1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        p2.addConstraint((FieldConstraint)sfc2);
        cp.addFactPattern((IFactPattern)p1);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\n(\nPerson( )\nor\nPerson( field2 == \"bar\" )\n)\nthen\nend\n";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraintsAllValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldType("String");
        comp2sfc2.setFieldName("field3");
        comp2sfc2.setOperator("==");
        comp2sfc2.setValue("$f3");
        comp2sfc2.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || ( field2 == \"bar\" && field3 == \"goo\" ) )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar", "goo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraintsFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldType("String");
        comp2sfc2.setFieldName("field3");
        comp2sfc2.setOperator("==");
        comp2sfc2.setValue("$f3");
        comp2sfc2.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraintsSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldType("String");
        comp2sfc2.setFieldName("field3");
        comp2sfc2.setOperator("==");
        comp2sfc2.setValue("$f3");
        comp2sfc2.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( ( field2 == \"bar\" ) )\nthen\nend\n";
        m.addRow(new String[]{null, "bar", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraintsThirdValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldType("String");
        comp2sfc2.setFieldName("field3");
        comp2sfc2.setOperator("==");
        comp2sfc2.setValue("$f3");
        comp2sfc2.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( ( field3 == \"goo\" ) )\nthen\nend\n";
        m.addRow(new String[]{null, null, "goo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints2AllValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || ( field2 == \"bar\" ) )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints2FirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints2SecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( ( field2 == \"bar\" ) )\nthen\nend\n";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints3AllValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc2);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || field2== \"bar\" || ( field3 == \"goo\" ) )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar", "goo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints3FirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc2);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints3SecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc2);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field2== \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{null, "bar", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints3ThirdValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc2);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( ( field3 == \"goo\" ) )\nthen\nend\n";
        m.addRow(new String[]{null, null, "goo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints4AllValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp1 = new CompositeFieldConstraint();
        comp1.setCompositeJunctionType("||");
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc2);
        p.addConstraint((FieldConstraint)comp1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("||");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldName("field4");
        comp2sfc2.setFieldType("String");
        comp2sfc2.setConstraintValueType(7);
        comp2sfc2.setValue("$f4");
        comp2sfc2.setOperator("==");
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        p.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || field2== \"bar\", field3 == \"goo\" || field4 == \"boo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar", "goo", "boo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints4FirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp1 = new CompositeFieldConstraint();
        comp1.setCompositeJunctionType("||");
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc2);
        p.addConstraint((FieldConstraint)comp1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("||");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldName("field4");
        comp2sfc2.setFieldType("String");
        comp2sfc2.setConstraintValueType(7);
        comp2sfc2.setValue("$f4");
        comp2sfc2.setOperator("==");
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        p.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null, null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints4SecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp1 = new CompositeFieldConstraint();
        comp1.setCompositeJunctionType("||");
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc2);
        p.addConstraint((FieldConstraint)comp1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("||");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldName("field4");
        comp2sfc2.setFieldType("String");
        comp2sfc2.setConstraintValueType(7);
        comp2sfc2.setValue("$f4");
        comp2sfc2.setOperator("==");
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        p.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field2== \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{null, "bar", null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints4ThirdValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp1 = new CompositeFieldConstraint();
        comp1.setCompositeJunctionType("||");
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc2);
        p.addConstraint((FieldConstraint)comp1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("||");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldName("field4");
        comp2sfc2.setFieldType("String");
        comp2sfc2.setConstraintValueType(7);
        comp2sfc2.setValue("$f4");
        comp2sfc2.setOperator("==");
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        p.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field3 == \"goo\" )\nthen\nend\n";
        m.addRow(new String[]{null, null, "goo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints4FourthValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp1 = new CompositeFieldConstraint();
        comp1.setCompositeJunctionType("||");
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc2);
        p.addConstraint((FieldConstraint)comp1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("||");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldName("field4");
        comp2sfc2.setFieldType("String");
        comp2sfc2.setConstraintValueType(7);
        comp2sfc2.setValue("$f4");
        comp2sfc2.setOperator("==");
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        p.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field4 == \"boo\" )\nthen\nend\n";
        m.addRow(new String[]{null, null, null, "boo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints5AllValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc2);
        SingleFieldConstraint comp1sfc3 = new SingleFieldConstraint();
        comp1sfc3.setFieldName("field3");
        comp1sfc3.setFieldType("String");
        comp1sfc3.setConstraintValueType(7);
        comp1sfc3.setValue("$f3");
        comp1sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc3);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || field2 == \"bar\" || field3 == \"goo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar", "goo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints5FirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc2);
        SingleFieldConstraint comp1sfc3 = new SingleFieldConstraint();
        comp1sfc3.setFieldName("field3");
        comp1sfc3.setFieldType("String");
        comp1sfc3.setConstraintValueType(7);
        comp1sfc3.setValue("$f3");
        comp1sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc3);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints5SecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc2);
        SingleFieldConstraint comp1sfc3 = new SingleFieldConstraint();
        comp1sfc3.setFieldName("field3");
        comp1sfc3.setFieldType("String");
        comp1sfc3.setConstraintValueType(7);
        comp1sfc3.setValue("$f3");
        comp1sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc3);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field2 == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{null, "bar", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints5ThirdValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc2);
        SingleFieldConstraint comp1sfc3 = new SingleFieldConstraint();
        comp1sfc3.setFieldName("field3");
        comp1sfc3.setFieldType("String");
        comp1sfc3.setConstraintValueType(7);
        comp1sfc3.setValue("$f3");
        comp1sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc3);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field3 == \"goo\" )\nthen\nend\n";
        m.addRow(new String[]{null, null, "goo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6AllValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(7);
        cfc1sfc1.setValue("$f1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(7);
        cfc1sfc2.setValue("$f2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(7);
        cfc2sfc1.setValue("$f3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(7);
        cfc2sfc2.setValue("$f4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(7);
        cfc3sfc1.setValue("$f5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(7);
        cfc3sfc2.setValue("$f6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"v1\" || field2 == \"v2\", field3 == \"v3\" || field4 == \"v4\", field5 == \"v5\" || field6 == \"v6\" )\nthen\nend\n";
        m.addRow(new String[]{"v1", "v2", "v3", "v4", "v5", "v6"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6NoValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(7);
        cfc1sfc1.setValue("$f1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(7);
        cfc1sfc2.setValue("$f2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(7);
        cfc2sfc1.setValue("$f3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(7);
        cfc2sfc2.setValue("$f4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(7);
        cfc3sfc1.setValue("$f5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(7);
        cfc3sfc2.setValue("$f6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nthen\nend\n";
        m.addRow(new String[]{null, null, null, null, null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6VariablesAndLiterals() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(7);
        cfc1sfc1.setValue("$f1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(1);
        cfc1sfc2.setValue("v2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(7);
        cfc2sfc1.setValue("$f3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(1);
        cfc2sfc2.setValue("v4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(7);
        cfc3sfc1.setValue("$f5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(1);
        cfc3sfc2.setValue("v6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"v1\" || field2 == \"v2\", field3 == \"v3\" || field4 == \"v4\", field5 == \"v5\" || field6 == \"v6\" )\nthen\nend\n";
        m.addRow(new String[]{"v1", "v3", "v5"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6VariablesNoValuesAndLiterals() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(7);
        cfc1sfc1.setValue("$f1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(1);
        cfc1sfc2.setValue("v2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(7);
        cfc2sfc1.setValue("$f3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(1);
        cfc2sfc2.setValue("v4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(7);
        cfc3sfc1.setValue("$f5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(1);
        cfc3sfc2.setValue("v6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field2 == \"v2\", field4 == \"v4\", field6 == \"v6\" )\nthen\nend\n";
        m.addRow(new String[]{null, null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6VariablesWithValuesAndLiterals() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(7);
        cfc1sfc1.setValue("$f1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(1);
        cfc1sfc2.setValue("v2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(7);
        cfc2sfc1.setValue("$f3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(1);
        cfc2sfc2.setValue("v4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(7);
        cfc3sfc1.setValue("$f5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(1);
        cfc3sfc2.setValue("v6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"v1\" || field2 == \"v2\", field3 == \"v3\" || field4 == \"v4\", field5 == \"v5\" || field6 == \"v6\" )\nthen\nend\n";
        m.addRow(new String[]{"v1", "v3", "v5"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6LiteralsAndVariablesNoValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(1);
        cfc1sfc1.setValue("v1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(7);
        cfc1sfc2.setValue("$f2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(1);
        cfc2sfc1.setValue("v3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(7);
        cfc2sfc2.setValue("$f4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(1);
        cfc3sfc1.setValue("v5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(7);
        cfc3sfc2.setValue("$f6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"v1\", field3 == \"v3\", field5 == \"v5\" )\nthen\nend\n";
        m.addRow(new String[]{null, null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6LiteralsAndVariablesWithValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(1);
        cfc1sfc1.setValue("v1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(7);
        cfc1sfc2.setValue("$f2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(1);
        cfc2sfc1.setValue("v3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(7);
        cfc2sfc2.setValue("$f4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(1);
        cfc3sfc1.setValue("v5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(7);
        cfc3sfc2.setValue("$f6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"v1\" || field2 == \"v2\", field3 == \"v3\" || field4 == \"v4\", field5 == \"v5\" || field6 == \"v6\" )\nthen\nend\n";
        m.addRow(new String[]{"v2", "v4", "v6"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testConnectiveConstraintBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        p1.addConstraint((FieldConstraint)X);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(7);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("$f2");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = connective;
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testConnectiveConstraintFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        p1.addConstraint((FieldConstraint)X);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(7);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("$f2");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = connective;
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testConnectiveConstraintSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        p1.addConstraint((FieldConstraint)X);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(7);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("$f2");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = connective;
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollect() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(new FactPattern("java.util.List"));
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List( ) from collect ( Person( field1 == \"foo\" ) ) \nthen\nend";
        m.addRow(new String[]{"foo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollectBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        FactPattern fp2 = new FactPattern("java.util.List");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("size");
        sfc2.setConstraintValueType(7);
        sfc2.setFieldType("Integer");
        sfc2.setOperator(">");
        sfc2.setValue("$f2");
        fp2.addConstraint((FieldConstraint)sfc2);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(fp2);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List( size > 1 ) from collect ( Person( field1 == \"foo\" ) ) \nthen\nend";
        m.addRow(new String[]{"1", "foo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollectFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        FactPattern fp2 = new FactPattern("java.util.List");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("size");
        sfc2.setConstraintValueType(7);
        sfc2.setFieldType("Integer");
        sfc2.setOperator(">");
        sfc2.setValue("$f2");
        fp2.addConstraint((FieldConstraint)sfc2);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(fp2);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List( size > 1 ) from collect ( Person( ) )\nthen\nend";
        m.addRow(new String[]{"1", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollectSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        FactPattern fp2 = new FactPattern("java.util.List");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("size");
        sfc2.setConstraintValueType(7);
        sfc2.setFieldType("Integer");
        sfc2.setOperator(">");
        sfc2.setValue("$f2");
        fp2.addConstraint((FieldConstraint)sfc2);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(fp2);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List() from collect ( Person( field1 == \"foo\" ) )then\nend";
        m.addRow(new String[]{null, "foo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testFromCollectFreeFormLineBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("Person( field1 == \"@{f1}\", field2 == \"@{f2}\" )");
        FactPattern fp = new FactPattern("java.util.List");
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)ffl);
        fac.setFactPattern(fp);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List() from collect ( Person( field1 == \"foo\", field2 == \"bar\" ) ) \nthen\nend";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testFromCollectFreeFormLineFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("Person( field1 == \"@{f1}\", field2 == \"@{f2}\" )");
        FactPattern fp = new FactPattern("java.util.List");
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)ffl);
        fac.setFactPattern(fp);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nend";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testFromCollectFreeFormLineSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("Person( field1 == \"@{f1}\", field2 == \"@{f2}\" )");
        FactPattern fp = new FactPattern("java.util.List");
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)ffl);
        fac.setFactPattern(fp);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nend";
        m.addRow(new String[]{null, "foo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollectMultipleSubPatternValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint("field2");
        sfc1.setConstraintValueType(7);
        sfc1.setFieldType("String");
        sfc1.setOperator("==");
        sfc1.setValue("$f2");
        fp.addConstraint((FieldConstraint)sfc1);
        FactPattern fp2 = new FactPattern("java.util.List");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("size");
        sfc2.setConstraintValueType(7);
        sfc2.setFieldType("Integer");
        sfc2.setOperator(">");
        sfc2.setValue("$f3");
        fp2.addConstraint((FieldConstraint)sfc2);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(fp2);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List( size > 1 ) from collect ( Person( field1 == \"foo\", field2 == \"bar\" ) ) \nthen\nend";
        m.addRow(new String[]{"1", "foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollectMultipleSubPatternValuesFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint("field2");
        sfc1.setConstraintValueType(7);
        sfc1.setFieldType("String");
        sfc1.setOperator("==");
        sfc1.setValue("$f2");
        fp.addConstraint((FieldConstraint)sfc1);
        FactPattern fp2 = new FactPattern("java.util.List");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("size");
        sfc2.setConstraintValueType(7);
        sfc2.setFieldType("Integer");
        sfc2.setOperator(">");
        sfc2.setValue("$f3");
        fp2.addConstraint((FieldConstraint)sfc2);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(fp2);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List( size > 1 ) from collect ( Person( field1 == \"foo\" ) ) \nthen\nend";
        m.addRow(new String[]{"1", "foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollectMultipleSubPatternValuesSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint("field2");
        sfc1.setConstraintValueType(7);
        sfc1.setFieldType("String");
        sfc1.setOperator("==");
        sfc1.setValue("$f2");
        fp.addConstraint((FieldConstraint)sfc1);
        FactPattern fp2 = new FactPattern("java.util.List");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("size");
        sfc2.setConstraintValueType(7);
        sfc2.setFieldType("Integer");
        sfc2.setOperator(">");
        sfc2.setValue("$f3");
        fp2.addConstraint((FieldConstraint)sfc2);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(fp2);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List( size > 1 ) from collect ( Person( field2 == \"bar\" ) ) \nthen\nend";
        m.addRow(new String[]{"1", null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testFreeFormLineBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("Person( field1 == \"@{f1}\", field2 == \"@{f2}\" )");
        m.addLhsItem((IPattern)ffl);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\", field2 == \"bar\" ) \nthen\nend";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testFreeFormLineFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("Person( field1 == \"@{f1}\", field2 == \"@{f2}\" )");
        m.addLhsItem((IPattern)ffl);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nend";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testFreeFormLineSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("Person( field1 == \"@{f1}\", field2 == \"@{f2}\" )");
        m.addLhsItem((IPattern)ffl);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nend";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionFreeFormLineBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("System.println( \"@{f1}\" + \"@{f2}\" );");
        m.addRhsItem((IAction)ffl);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nSystem.println( \"foo\" + \"bar\" );end";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionFreeFormLineFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("System.println( \"@{f1}\" + \"@{f2}\" );");
        m.addRhsItem((IAction)ffl);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nend";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionFreeFormLineSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("System.println( \"@{f1}\" + \"@{f2}\" );");
        m.addRhsItem((IAction)ffl);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nend";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionInsertFactBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionInsertFact aif = new ActionInsertFact("Present");
        aif.setBoundName("f0");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        aif.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        aif.addFieldValue(afv1);
        m.addRhsItem((IAction)aif);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\nPresent f0 = new Present();\nf0.setField1(\"foo\");\nf0.setField2(\"bar\");\ninsert(f0);\nend";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionInsertFactZeroValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionInsertFact aif = new ActionInsertFact("Present");
        aif.setBoundName("f0");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        aif.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        aif.addFieldValue(afv1);
        m.addRhsItem((IAction)aif);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\nPresent f0 = new Present();\ninsert(f0);\nend";
        m.addRow(new String[]{null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionInsertFactFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionInsertFact aif = new ActionInsertFact("Present");
        aif.setBoundName("f0");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        aif.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        aif.addFieldValue(afv1);
        m.addRhsItem((IAction)aif);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\nPresent f0 = new Present();\nf0.setField1(\"foo\");\ninsert(f0);\nend";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionInsertFactSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionInsertFact aif = new ActionInsertFact("Present");
        aif.setBoundName("f0");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        aif.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        aif.addFieldValue(afv1);
        m.addRhsItem((IAction)aif);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\nPresent f0 = new Present();\nf0.setField2(\"bar\");\ninsert(f0);\nend";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionUpdateFactBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionSetField asf = new ActionSetField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        asf.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        asf.addFieldValue(afv1);
        m.addRhsItem((IAction)asf);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\n$p.setField1(\"foo\");\n$p.setField2(\"bar\");\nend";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionUpdateFactZeroValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionSetField asf = new ActionSetField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        asf.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        asf.addFieldValue(afv1);
        m.addRhsItem((IAction)asf);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\nend";
        m.addRow(new String[]{null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionUpdateFactFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionSetField asf = new ActionSetField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        asf.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        asf.addFieldValue(afv1);
        m.addRhsItem((IAction)asf);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\n$p.setField1(\"foo\");\nend";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionUpdateFactSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionSetField asf = new ActionSetField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        asf.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        asf.addFieldValue(afv1);
        m.addRhsItem((IAction)asf);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\n$p.setField2(\"bar\");\nend";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testEmptyFreeForm() {
        TemplateModel m = new TemplateModel();
        m.name = "Empty FreeFormLine";
        FreeFormLine fl = new FreeFormLine();
        m.addLhsItem((IPattern)fl);
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        fp.addConstraint((FieldConstraint)sfc1);
        m.addLhsItem((IPattern)fp);
        FreeFormLine fr = new FreeFormLine();
        m.addRhsItem((IAction)fr);
        ActionSetField asf = new ActionSetField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setType("String");
        afv0.setField("field1");
        afv0.setValue("$asf1");
        asf.addFieldValue(afv0);
        m.addRhsItem((IAction)asf);
        String expected = "rule \"Empty FreeFormLine_0\"\ndialect \"mvel\"\nwhen\n$p : Person( field1 == \"foo\" )\nthen\n$p.setField1(\"bar\");\nend";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionModifyTwoFieldsFirstTemplateSecondTemplate1() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionUpdateField auf1 = new ActionUpdateField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        auf1.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        auf1.addFieldValue(afv1);
        m.addRhsItem((IAction)auf1);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  modify( $p ) {\n    setField1(\"foo\"),\n    setField2(\"bar\")\n  }\nend";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionModifyTwoFieldsFirstTemplateSecondTemplate2() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionUpdateField auf1 = new ActionUpdateField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        auf1.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        auf1.addFieldValue(afv1);
        m.addRhsItem((IAction)auf1);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  modify( $p ) {\n    setField1(\"foo\")\n  }\nend";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionModifyTwoFieldsFirstTemplateSecondTemplate3() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionUpdateField auf1 = new ActionUpdateField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        auf1.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        auf1.addFieldValue(afv1);
        m.addRhsItem((IAction)auf1);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  modify( $p ) {\n    setField2(\"bar\")\n  }\nend";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionModifyTwoFieldsFirstTemplateSecondLiteral1() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionUpdateField auf1 = new ActionUpdateField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        auf1.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(1);
        afv1.setField("field2");
        afv1.setValue("bar");
        auf1.addFieldValue(afv1);
        m.addRhsItem((IAction)auf1);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  modify( $p ) {\n    setField1(\"foo\"),\n    setField2(\"bar\")\n  }\nend";
        m.addRow(new String[]{"foo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionModifyTwoFieldsFirstTemplateSecondLiteral2() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionUpdateField auf1 = new ActionUpdateField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        auf1.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(1);
        afv1.setField("field2");
        afv1.setValue("bar");
        auf1.addFieldValue(afv1);
        m.addRhsItem((IAction)auf1);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  modify( $p ) {\n    setField2(\"bar\")\n  }\nend";
        m.addRow(new String[]{null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionModifyTwoFieldsFirstLiteralSecondTemplate1() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionUpdateField auf1 = new ActionUpdateField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(1);
        afv0.setField("field1");
        afv0.setValue("foo");
        auf1.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        auf1.addFieldValue(afv1);
        m.addRhsItem((IAction)auf1);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  modify( $p ) {\n    setField1(\"foo\"),\n    setField2(\"bar\")\n  }\nend";
        m.addRow(new String[]{"bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionModifyTwoFieldsFirstLiteralSecondTemplate2() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionUpdateField auf1 = new ActionUpdateField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(1);
        afv0.setField("field1");
        afv0.setValue("foo");
        auf1.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        auf1.addFieldValue(afv1);
        m.addRhsItem((IAction)auf1);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  modify( $p ) {\n    setField1(\"foo\")\n  }\nend";
        m.addRow(new String[]{null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testUpdateModifyMultipleFieldsWithMultipleSkipped1() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionUpdateField auf1 = new ActionUpdateField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        auf1.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        auf1.addFieldValue(afv1);
        ActionFieldValue afv2 = new ActionFieldValue();
        afv2.setNature(7);
        afv2.setField("field3");
        afv2.setValue("$f3");
        auf1.addFieldValue(afv2);
        m.addRhsItem((IAction)auf1);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  modify( $p ) {\n    setField1(\"v1\"),\n    setField2(\"v2\"),\n    setField3(\"v3\")\n  }\nend";
        m.addRow(new String[]{"v1", "v2", "v3"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testUpdateModifyMultipleFieldsWithMultipleSkipped2() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionUpdateField auf1 = new ActionUpdateField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        auf1.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        auf1.addFieldValue(afv1);
        ActionFieldValue afv2 = new ActionFieldValue();
        afv2.setNature(7);
        afv2.setField("field3");
        afv2.setValue("$f3");
        auf1.addFieldValue(afv2);
        m.addRhsItem((IAction)auf1);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  modify( $p ) {\n    setField2(\"v2\"),\n    setField3(\"v3\")\n  }\nend";
        m.addRow(new String[]{null, "v2", "v3"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testUpdateModifyMultipleFieldsWithMultipleSkipped3() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionUpdateField auf1 = new ActionUpdateField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        auf1.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        auf1.addFieldValue(afv1);
        ActionFieldValue afv2 = new ActionFieldValue();
        afv2.setNature(7);
        afv2.setField("field3");
        afv2.setValue("$f3");
        auf1.addFieldValue(afv2);
        m.addRhsItem((IAction)auf1);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  modify( $p ) {\n    setField3(\"v3\")\n  }\nend";
        m.addRow(new String[]{null, null, "v3"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testUpdateModifyMultipleFieldsWithMultipleSkipped4() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionUpdateField auf1 = new ActionUpdateField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        auf1.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        auf1.addFieldValue(afv1);
        ActionFieldValue afv2 = new ActionFieldValue();
        afv2.setNature(7);
        afv2.setField("field3");
        afv2.setValue("$f3");
        auf1.addFieldValue(afv2);
        m.addRhsItem((IAction)auf1);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  modify( $p ) {\n    setField1(\"v1\"),\n    setField3(\"v3\")\n  }\nend";
        m.addRow(new String[]{"v1", null, "v3"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testLHSNonEmptyStringValues() {
        FactPattern fp = new FactPattern("Smurf");
        fp.setBoundName("p1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setOperator("==");
        sfc1.setFactType("Smurf");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setOperator("==");
        sfc2.setFactType("Smurf");
        sfc2.setFieldName("age");
        sfc2.setFieldType("Integer");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        fp.addConstraint((FieldConstraint)sfc1);
        fp.addConstraint((FieldConstraint)sfc2);
        TemplateModel m1 = new TemplateModel();
        m1.addLhsItem((IPattern)fp);
        m1.name = "r1";
        m1.addRow(new String[]{null, null});
        String expected1 = "rule \"r1_0\"\n  dialect \"mvel\"\n  when\n  then\nend";
        this.checkMarshall("rule \"r1_0\"\n  dialect \"mvel\"\n  when\n  then\nend", (RuleModel)m1);
        TemplateModel m2 = new TemplateModel();
        m2.addLhsItem((IPattern)fp);
        m2.name = "r2";
        m2.addRow(new String[]{"   ", "35"});
        String expected2 = "rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( age == 35 )\n  then\nend";
        this.checkMarshall("rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( age == 35 )\n  then\nend", (RuleModel)m2);
        TemplateModel m3 = new TemplateModel();
        m3.addLhsItem((IPattern)fp);
        m3.name = "r3";
        m3.addRow(new String[]{"", null});
        String expected3 = "rule \"r3_0\"\n  dialect \"mvel\"\n  when\n  then\nend";
        this.checkMarshall("rule \"r3_0\"\n  dialect \"mvel\"\n  when\n  then\nend", (RuleModel)m3);
        TemplateModel m4 = new TemplateModel();
        m4.addLhsItem((IPattern)fp);
        m4.name = "r4";
        m4.addRow(new String[]{"", "35"});
        String expected4 = "rule \"r4_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( age == 35 )\n  then\nend";
        this.checkMarshall("rule \"r4_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( age == 35 )\n  then\nend", (RuleModel)m4);
    }

    @Test
    public void testLHSDelimitedNonEmptyStringValues() {
        FactPattern fp = new FactPattern("Smurf");
        fp.setBoundName("p1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setOperator("==");
        sfc1.setFactType("Smurf");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setOperator("==");
        sfc2.setFactType("Smurf");
        sfc2.setFieldName("age");
        sfc2.setFieldType("Integer");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        fp.addConstraint((FieldConstraint)sfc1);
        fp.addConstraint((FieldConstraint)sfc2);
        TemplateModel m1 = new TemplateModel();
        m1.addLhsItem((IPattern)fp);
        m1.name = "r1";
        m1.addRow(new String[]{null, null});
        String expected1 = "rule \"r1_0\"\n  dialect \"mvel\"\n  when\n  then\nend";
        this.checkMarshall("rule \"r1_0\"\n  dialect \"mvel\"\n  when\n  then\nend", (RuleModel)m1);
        TemplateModel m2 = new TemplateModel();
        m2.addLhsItem((IPattern)fp);
        m2.name = "r2";
        m2.addRow(new String[]{"\"   \"", "35"});
        String expected2 = "rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"   \", age == 35 )\n  then\nend";
        this.checkMarshall("rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"   \", age == 35 )\n  then\nend", (RuleModel)m2);
        TemplateModel m3 = new TemplateModel();
        m3.addLhsItem((IPattern)fp);
        m3.name = "r3";
        m3.addRow(new String[]{"\"\"", null});
        String expected3 = "rule \"r3_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"\" )\n  then\nend";
        this.checkMarshall("rule \"r3_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"\" )\n  then\nend", (RuleModel)m3);
        TemplateModel m4 = new TemplateModel();
        m4.addLhsItem((IPattern)fp);
        m4.name = "r4";
        m4.addRow(new String[]{"\"\"", "35"});
        String expected4 = "rule \"r4_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"\", age == 35 )\n  then\nend";
        this.checkMarshall("rule \"r4_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"\", age == 35 )\n  then\nend", (RuleModel)m4);
    }

    @Test
    public void testRHSNonEmptyStringValues() {
        FactPattern fp = new FactPattern("Smurf");
        fp.setBoundName("p1");
        ActionUpdateField auf1 = new ActionUpdateField("p1");
        auf1.addFieldValue(new ActionFieldValue("name", "$name", "String"));
        auf1.getFieldValues()[0].setNature(7);
        ActionUpdateField auf2 = new ActionUpdateField("p1");
        auf2.addFieldValue(new ActionFieldValue("age", "$age", "Integer"));
        auf2.getFieldValues()[0].setNature(7);
        TemplateModel m1 = new TemplateModel();
        m1.addLhsItem((IPattern)fp);
        m1.addRhsItem((IAction)auf1);
        m1.addRhsItem((IAction)auf2);
        m1.name = "r1";
        m1.addRow(new String[]{null, null});
        String expected1 = "rule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\nend";
        this.checkMarshall("rule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\nend", (RuleModel)m1);
        TemplateModel m2 = new TemplateModel();
        m2.addLhsItem((IPattern)fp);
        m2.addRhsItem((IAction)auf1);
        m2.addRhsItem((IAction)auf2);
        m2.name = "r2";
        m2.addRow(new String[]{"   ", "35"});
        String expected2 = "rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\n    modify( p1 ) {\n      setAge( 35 )\n    }\nend";
        this.checkMarshall("rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\n    modify( p1 ) {\n      setAge( 35 )\n    }\nend", (RuleModel)m2);
        TemplateModel m3 = new TemplateModel();
        m3.addLhsItem((IPattern)fp);
        m3.addRhsItem((IAction)auf1);
        m3.addRhsItem((IAction)auf2);
        m3.name = "r3";
        m3.addRow(new String[]{"", null});
        String expected3 = "rule \"r3_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\nend";
        this.checkMarshall("rule \"r3_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\nend", (RuleModel)m3);
        TemplateModel m4 = new TemplateModel();
        m4.addLhsItem((IPattern)fp);
        m4.addRhsItem((IAction)auf1);
        m4.addRhsItem((IAction)auf2);
        m4.name = "r4";
        m4.addRow(new String[]{"", "35"});
        String expected4 = "rule \"r4_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\n    modify( p1 ) {\n      setAge( 35 )\n    }\nend";
        this.checkMarshall("rule \"r4_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\n    modify( p1 ) {\n      setAge( 35 )\n    }\nend", (RuleModel)m4);
    }

    @Test
    public void testRHSDelimitedNonEmptyStringValues() {
        FactPattern fp = new FactPattern("Smurf");
        fp.setBoundName("p1");
        ActionUpdateField auf1 = new ActionUpdateField("p1");
        auf1.addFieldValue(new ActionFieldValue("name", "$name", "String"));
        auf1.getFieldValues()[0].setNature(7);
        ActionUpdateField auf2 = new ActionUpdateField("p1");
        auf2.addFieldValue(new ActionFieldValue("age", "$age", "Integer"));
        auf2.getFieldValues()[0].setNature(7);
        TemplateModel m1 = new TemplateModel();
        m1.addLhsItem((IPattern)fp);
        m1.addRhsItem((IAction)auf1);
        m1.addRhsItem((IAction)auf2);
        m1.name = "r1";
        m1.addRow(new String[]{null, null});
        String expected1 = "rule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\nend";
        this.checkMarshall("rule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\nend", (RuleModel)m1);
        TemplateModel m2 = new TemplateModel();
        m2.addLhsItem((IPattern)fp);
        m2.addRhsItem((IAction)auf1);
        m2.addRhsItem((IAction)auf2);
        m2.name = "r2";
        m2.addRow(new String[]{"\"   \"", "35"});
        String expected2 = "rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\n    modify( p1 ) {\n      setName( \"   \" ),\n      setAge( 35 )\n    }\nend";
        this.checkMarshall("rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\n    modify( p1 ) {\n      setName( \"   \" ),\n      setAge( 35 )\n    }\nend", (RuleModel)m2);
        TemplateModel m3 = new TemplateModel();
        m3.addLhsItem((IPattern)fp);
        m3.addRhsItem((IAction)auf1);
        m3.addRhsItem((IAction)auf2);
        m3.name = "r3";
        m3.addRow(new String[]{"\"\"", null});
        String expected3 = "rule \"r3_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\n    modify( p1 ) {\n      setName( \"\" )\n    }\nend";
        this.checkMarshall("rule \"r3_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\n    modify( p1 ) {\n      setName( \"\" )\n    }\nend", (RuleModel)m3);
        TemplateModel m4 = new TemplateModel();
        m4.addLhsItem((IPattern)fp);
        m4.addRhsItem((IAction)auf1);
        m4.addRhsItem((IAction)auf2);
        m4.name = "r4";
        m4.addRow(new String[]{"\"\"", "35"});
        String expected4 = "rule \"r4_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\n    modify( p1 ) {\n      setName( \"\" ),\n      setAge( 35 )\n    }\nend";
        this.checkMarshall("rule \"r4_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf()\n  then\n    modify( p1 ) {\n      setName( \"\" ),\n      setAge( 35 )\n    }\nend", (RuleModel)m4);
    }

    @Test
    public void checkLHSConstraintSeparatorWithTemplateKeyAndLiteral() {
        FactPattern fp = new FactPattern("Smurf");
        fp.setBoundName("p1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setOperator("==");
        sfc1.setFactType("Smurf");
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setOperator("==");
        sfc2.setFactType("Smurf");
        sfc2.setFieldName("field1");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        SingleFieldConstraint sfc3 = new SingleFieldConstraint();
        sfc3.setOperator("==");
        sfc3.setFactType("Smurf");
        sfc3.setFieldName("field1");
        sfc3.setFieldType("String");
        sfc3.setConstraintValueType(1);
        sfc3.setValue("value");
        fp.addConstraint((FieldConstraint)sfc1);
        fp.addConstraint((FieldConstraint)sfc2);
        fp.addConstraint((FieldConstraint)sfc3);
        TemplateModel m1 = new TemplateModel();
        m1.addLhsItem((IPattern)fp);
        m1.name = "r1";
        m1.addRow(new String[]{null, null});
        String expected1 = "rule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value\" )\n  then\nend";
        this.checkMarshall("rule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value\" )\n  then\nend", (RuleModel)m1);
        TemplateModel m2 = new TemplateModel();
        m2.addLhsItem((IPattern)fp);
        m2.name = "r2";
        m2.addRow(new String[]{"t1", "t2"});
        String expected2 = "rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"t1\", field1 == \"t2\", field1 == \"value\" )\n  then\nend";
        this.checkMarshall("rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"t1\", field1 == \"t2\", field1 == \"value\" )\n  then\nend", (RuleModel)m2);
        TemplateModel m3 = new TemplateModel();
        m3.addLhsItem((IPattern)fp);
        m3.name = "r3";
        m3.addRow(new String[]{"t1", null});
        String expected3 = "rule \"r3_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"t1\", field1 == \"value\" )\n  then\nend";
        this.checkMarshall("rule \"r3_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"t1\", field1 == \"value\" )\n  then\nend", (RuleModel)m3);
        TemplateModel m4 = new TemplateModel();
        m4.addLhsItem((IPattern)fp);
        m4.name = "r4";
        m4.addRow(new String[]{null, "t2"});
        String expected4 = "rule \"r4_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"t2\", field1 == \"value\" )\n  then\nend";
        this.checkMarshall("rule \"r4_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"t2\", field1 == \"value\" )\n  then\nend", (RuleModel)m4);
    }

    @Test
    public void checkLHSConstraintSeparatorWithEmptyTemplateKeyAndLiteralAndNonEmptyTemplateKey() {
        FactPattern fp = new FactPattern("Smurf");
        fp.setBoundName("p1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setOperator("==");
        sfc1.setFactType("Smurf");
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setOperator("==");
        sfc2.setFactType("Smurf");
        sfc2.setFieldName("field1");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(1);
        sfc2.setValue("value");
        SingleFieldConstraint sfc3 = new SingleFieldConstraint();
        sfc3.setOperator("==");
        sfc3.setFactType("Smurf");
        sfc3.setFieldName("field1");
        sfc3.setFieldType("String");
        sfc3.setConstraintValueType(7);
        sfc3.setValue("$f2");
        fp.addConstraint((FieldConstraint)sfc1);
        fp.addConstraint((FieldConstraint)sfc2);
        fp.addConstraint((FieldConstraint)sfc3);
        TemplateModel m1 = new TemplateModel();
        m1.addLhsItem((IPattern)fp);
        m1.name = "r1";
        m1.addRow(new String[]{null, null});
        String expected1 = "rule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value\" )\n  then\nend";
        this.checkMarshall("rule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value\" )\n  then\nend", (RuleModel)m1);
        TemplateModel m2 = new TemplateModel();
        m2.addLhsItem((IPattern)fp);
        m2.name = "r2";
        m2.addRow(new String[]{"t1", "t2"});
        String expected2 = "rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"t1\", field1 == \"value\", field1 == \"t2\" )\n  then\nend";
        this.checkMarshall("rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"t1\", field1 == \"value\", field1 == \"t2\" )\n  then\nend", (RuleModel)m2);
        TemplateModel m3 = new TemplateModel();
        m3.addLhsItem((IPattern)fp);
        m3.name = "r3";
        m3.addRow(new String[]{"t1", null});
        String expected3 = "rule \"r3_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"t1\", field1 == \"value\" )\n  then\nend";
        this.checkMarshall("rule \"r3_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"t1\", field1 == \"value\" )\n  then\nend", (RuleModel)m3);
        TemplateModel m4 = new TemplateModel();
        m4.addLhsItem((IPattern)fp);
        m4.name = "r4";
        m4.addRow(new String[]{null, "t2"});
        String expected4 = "rule \"r4_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value\", field1 == \"t2\" )\n  then\nend";
        this.checkMarshall("rule \"r4_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value\", field1 == \"t2\" )\n  then\nend", (RuleModel)m4);
    }

    @Test
    public void checkLHSMultipleFactPatternsWhenPattern1LiteralPattern2Template() {
        FactPattern fp1 = new FactPattern("Smurf");
        fp1.setBoundName("p1");
        SingleFieldConstraint p1sfc1 = new SingleFieldConstraint();
        p1sfc1.setOperator("==");
        p1sfc1.setFactType("Smurf");
        p1sfc1.setFieldName("field1");
        p1sfc1.setFieldType("String");
        p1sfc1.setConstraintValueType(1);
        p1sfc1.setValue("value1");
        SingleFieldConstraint p1sfc2 = new SingleFieldConstraint();
        p1sfc2.setOperator("==");
        p1sfc2.setFactType("Smurf");
        p1sfc2.setFieldName("field2");
        p1sfc2.setFieldType("String");
        p1sfc2.setConstraintValueType(1);
        p1sfc2.setValue("value2");
        fp1.addConstraint((FieldConstraint)p1sfc1);
        fp1.addConstraint((FieldConstraint)p1sfc2);
        FactPattern fp2 = new FactPattern("Smurf");
        fp2.setBoundName("p2");
        SingleFieldConstraint p2sfc1 = new SingleFieldConstraint();
        p2sfc1.setOperator("==");
        p2sfc1.setFactType("Smurf");
        p2sfc1.setFieldName("field3");
        p2sfc1.setFieldType("String");
        p2sfc1.setConstraintValueType(7);
        p2sfc1.setValue("$key");
        fp2.addConstraint((FieldConstraint)p2sfc1);
        TemplateModel m1 = new TemplateModel();
        m1.addLhsItem((IPattern)fp1);
        m1.addLhsItem((IPattern)fp2);
        m1.name = "r1";
        m1.addRow(new String[]{null});
        String expected1 = "rule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value1\", field2 == \"value2\" )\n  then\nend";
        this.checkMarshall("rule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value1\", field2 == \"value2\" )\n  then\nend", (RuleModel)m1);
        TemplateModel m2 = new TemplateModel();
        m2.addLhsItem((IPattern)fp1);
        m2.addLhsItem((IPattern)fp2);
        m2.name = "r2";
        m2.addRow(new String[]{"value3"});
        String expected2 = "rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value1\", field2 == \"value2\" )\n    p2 : Smurf( field3 == \"value3\" )\n  then\nend";
        this.checkMarshall("rule \"r2_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value1\", field2 == \"value2\" )\n    p2 : Smurf( field3 == \"value3\" )\n  then\nend", (RuleModel)m2);
    }

    @Test
    public void checkPattern1StrictlyLiteralPattern2StrictlyTemplate() {
        FactPattern fp1 = new FactPattern("Smurf");
        fp1.setBoundName("p1");
        SingleFieldConstraint p1sfc1 = new SingleFieldConstraint();
        p1sfc1.setOperator("==");
        p1sfc1.setFactType("Smurf");
        p1sfc1.setFieldName("field1");
        p1sfc1.setFieldType("String");
        p1sfc1.setConstraintValueType(1);
        p1sfc1.setValue("value1");
        SingleFieldConstraint p1sfc2 = new SingleFieldConstraint();
        p1sfc2.setOperator("==");
        p1sfc2.setFactType("Smurf");
        p1sfc2.setFieldName("field2");
        p1sfc2.setFieldType("Integer");
        p1sfc2.setConstraintValueType(1);
        p1sfc2.setValue("123");
        ActionUpdateField p1auf1 = new ActionUpdateField("p1");
        p1auf1.addFieldValue(new ActionFieldValue("field1", "newValue", "String"));
        p1auf1.getFieldValues()[0].setNature(1);
        ActionUpdateField p1auf2 = new ActionUpdateField("p1");
        p1auf2.addFieldValue(new ActionFieldValue("field2", "12345", "Integer"));
        p1auf2.getFieldValues()[0].setNature(1);
        fp1.addConstraint((FieldConstraint)p1sfc1);
        fp1.addConstraint((FieldConstraint)p1sfc2);
        FactPattern fp2 = new FactPattern("Smurf");
        fp2.setBoundName("p2");
        SingleFieldConstraint p2sfc1 = new SingleFieldConstraint();
        p2sfc1.setOperator("==");
        p2sfc1.setFactType("Smurf");
        p2sfc1.setFieldName("field1");
        p2sfc1.setFieldType("String");
        p2sfc1.setConstraintValueType(7);
        p2sfc1.setValue("$oldField1");
        SingleFieldConstraint p2sfc2 = new SingleFieldConstraint();
        p2sfc2.setOperator("==");
        p2sfc2.setFactType("Smurf");
        p2sfc2.setFieldName("field2");
        p2sfc2.setFieldType("Integer");
        p2sfc2.setConstraintValueType(7);
        p2sfc2.setValue("$oldField2");
        ActionUpdateField p2auf1 = new ActionUpdateField("p2");
        p2auf1.addFieldValue(new ActionFieldValue("field1", "$newField1", "String"));
        p2auf1.getFieldValues()[0].setNature(7);
        ActionUpdateField p2auf2 = new ActionUpdateField("p2");
        p2auf2.addFieldValue(new ActionFieldValue("field2", "$newField2", "Integer"));
        p2auf2.getFieldValues()[0].setNature(7);
        fp2.addConstraint((FieldConstraint)p2sfc1);
        fp2.addConstraint((FieldConstraint)p2sfc2);
        TemplateModel m1 = new TemplateModel();
        m1.addLhsItem((IPattern)fp1);
        m1.addLhsItem((IPattern)fp2);
        m1.addRhsItem((IAction)p1auf1);
        m1.addRhsItem((IAction)p1auf2);
        m1.addRhsItem((IAction)p2auf1);
        m1.addRhsItem((IAction)p2auf2);
        m1.name = "r1";
        m1.addRow(new String[]{null, null, null, null});
        String expected1 = "rule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value1\", field2 == 123 )\n  then\n    modify( p1 ) {       setField1( \"newValue\" ),       setField2( 12345 )    }end";
        this.checkMarshall("rule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value1\", field2 == 123 )\n  then\n    modify( p1 ) {       setField1( \"newValue\" ),       setField2( 12345 )    }end", (RuleModel)m1);
        m1.addRow(new String[]{"abc", "0", "def", "1"});
        String expected2 = "rule \"r1_1\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value1\", field2 == 123 )\n    p2 : Smurf( field1 == \"abc\", field2 == 0 )\n  then\n    modify( p1 ) {       setField1( \"newValue\" ),       setField2( 12345 )    }    modify( p2 ) {       setField1( \"def\" ),       setField2( 1 )    }end";
        this.checkMarshall("rule \"r1_1\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value1\", field2 == 123 )\n    p2 : Smurf( field1 == \"abc\", field2 == 0 )\n  then\n    modify( p1 ) {       setField1( \"newValue\" ),       setField2( 12345 )    }    modify( p2 ) {       setField1( \"def\" ),       setField2( 1 )    }endrule \"r1_0\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( field1 == \"value1\", field2 == 123 )\n  then\n    modify( p1 ) {       setField1( \"newValue\" ),       setField2( 12345 )    }end", (RuleModel)m1);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }
}

