/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.template.backend;

import java.io.InputStream;
import java.io.InputStreamReader;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.DSLVariableValue;
import org.drools.workbench.models.guided.template.backend.RuleTemplateModelXMLPersistenceImpl;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.junit.Assert;
import org.junit.Test;

public class RuleTemplateModelXMLLegacyPersistenceTest {
    @Test
    public void testUnmarshalDSLVariableValuesLegacy() {
        String xml = "<rule><name>BugReportRule</name><modelVersion>1.0</modelVersion><attributes/><metadataList/><lhs><dslSentence><definition>If processInstance</definition><values/></dslSentence></lhs><rhs><dslSentence><definition>MyLog {myout}</definition><values><string>sample out rule 1</string><string>myout</string></values></dslSentence></rhs><isNegated>false</isNegated></rule>";
        TemplateModel rm = RuleTemplateModelXMLPersistenceImpl.getInstance().unmarshal("<rule><name>BugReportRule</name><modelVersion>1.0</modelVersion><attributes/><metadataList/><lhs><dslSentence><definition>If processInstance</definition><values/></dslSentence></lhs><rhs><dslSentence><definition>MyLog {myout}</definition><values><string>sample out rule 1</string><string>myout</string></values></dslSentence></rhs><isNegated>false</isNegated></rule>");
        Assert.assertNotNull((Object)rm);
        Assert.assertEquals((long)1L, (long)rm.lhs.length);
        Assert.assertTrue((boolean)(rm.lhs[0] instanceof DSLSentence));
        DSLSentence dslPattern = (DSLSentence)rm.lhs[0];
        Assert.assertEquals((Object)"If processInstance", (Object)dslPattern.getDefinition());
        Assert.assertEquals((long)0L, (long)dslPattern.getValues().size());
        Assert.assertEquals((long)1L, (long)rm.rhs.length);
        Assert.assertTrue((boolean)(rm.rhs[0] instanceof DSLSentence));
        DSLSentence dslAction = (DSLSentence)rm.rhs[0];
        Assert.assertEquals((Object)"MyLog {myout}", (Object)dslAction.getDefinition());
        Assert.assertEquals((long)2L, (long)dslAction.getValues().size());
        Assert.assertTrue((boolean)(dslAction.getValues().get(0) instanceof DSLVariableValue));
        Assert.assertTrue((boolean)(dslAction.getValues().get(1) instanceof DSLVariableValue));
        Assert.assertEquals((Object)"sample out rule 1", (Object)((DSLVariableValue)dslAction.getValues().get(0)).getValue());
        Assert.assertEquals((Object)"myout", (Object)((DSLVariableValue)dslAction.getValues().get(1)).getValue());
    }

    @Test
    public void testUnmarshalDSLVariableValues() {
        String xml = "<rule><name>BugReportRule</name><modelVersion>1.0</modelVersion><attributes/><metadataList/><lhs><dslSentence><definition>If processInstance</definition><values/></dslSentence></lhs><rhs><dslSentence><definition>MyLog {myout}</definition><values><org.drools.workbench.models.datamodel.rule.DSLVariableValue><value>5-4 sample out</value></org.drools.workbench.models.datamodel.rule.DSLVariableValue><org.drools.workbench.models.datamodel.rule.DSLVariableValue><value>myout</value></org.drools.workbench.models.datamodel.rule.DSLVariableValue></values></dslSentence></rhs><isNegated>false</isNegated></rule>";
        TemplateModel rm = RuleTemplateModelXMLPersistenceImpl.getInstance().unmarshal("<rule><name>BugReportRule</name><modelVersion>1.0</modelVersion><attributes/><metadataList/><lhs><dslSentence><definition>If processInstance</definition><values/></dslSentence></lhs><rhs><dslSentence><definition>MyLog {myout}</definition><values><org.drools.workbench.models.datamodel.rule.DSLVariableValue><value>5-4 sample out</value></org.drools.workbench.models.datamodel.rule.DSLVariableValue><org.drools.workbench.models.datamodel.rule.DSLVariableValue><value>myout</value></org.drools.workbench.models.datamodel.rule.DSLVariableValue></values></dslSentence></rhs><isNegated>false</isNegated></rule>");
        Assert.assertNotNull((Object)rm);
        Assert.assertEquals((long)1L, (long)rm.lhs.length);
        Assert.assertTrue((boolean)(rm.lhs[0] instanceof DSLSentence));
        DSLSentence dslPattern = (DSLSentence)rm.lhs[0];
        Assert.assertEquals((Object)"If processInstance", (Object)dslPattern.getDefinition());
        Assert.assertEquals((long)0L, (long)dslPattern.getValues().size());
        Assert.assertEquals((long)1L, (long)rm.rhs.length);
        Assert.assertTrue((boolean)(rm.rhs[0] instanceof DSLSentence));
        DSLSentence dslAction = (DSLSentence)rm.rhs[0];
        Assert.assertEquals((Object)"MyLog {myout}", (Object)dslAction.getDefinition());
        Assert.assertEquals((long)2L, (long)dslAction.getValues().size());
        Assert.assertTrue((boolean)(dslAction.getValues().get(0) instanceof DSLVariableValue));
        Assert.assertTrue((boolean)(dslAction.getValues().get(1) instanceof DSLVariableValue));
        Assert.assertEquals((Object)"5-4 sample out", (Object)((DSLVariableValue)dslAction.getValues().get(0)).getValue());
        Assert.assertEquals((Object)"myout", (Object)((DSLVariableValue)dslAction.getValues().get(1)).getValue());
    }

    @Test
    public void testBackwardsCompat() throws Exception {
        TemplateModel m2 = RuleTemplateModelXMLPersistenceImpl.getInstance().unmarshal(RuleTemplateModelXMLLegacyPersistenceTest.loadResource("existing_brl.xml"));
        Assert.assertNotNull((Object)m2);
        Assert.assertEquals((long)3L, (long)m2.rhs.length);
    }

    public static String loadResource(String name) throws Exception {
        InputStream in = RuleTemplateModelXMLLegacyPersistenceTest.class.getResourceAsStream(name);
        InputStreamReader reader = new InputStreamReader(in);
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }
}

