/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.template.shared;

import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.junit.Assert;
import org.junit.Test;

public class TemplateModelTest {
    @Test
    public void testAddRowInvalidColumnCount() throws Exception {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        try {
            m.addRow(new String[0]);
            Assert.fail((String)"Expected IlegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals((Object)"Invalid numbers of columns: 0 expected: 1", (Object)iae.getMessage());
        }
    }

    @Test
    public void sameFieldSameVariable() throws Exception {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        m.lhs = new IPattern[1];
        FactPattern factPattern = new FactPattern();
        m.lhs[0] = factPattern;
        factPattern.addConstraint((FieldConstraint)this.makeConstraint("Applicant", "age", "Integer", "$default", "=="));
        factPattern.addConstraint((FieldConstraint)this.makeConstraint("Applicant", "age", "Integer", "$default", "=="));
        Assert.assertEquals((long)1L, (long)m.getInterpolationVariablesList().length);
        Assert.assertEquals((Object)"Integer", (Object)m.getInterpolationVariablesList()[0].getDataType());
    }

    @Test
    public void sameVariableFroTwoDifferentTypes() throws Exception {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        m.lhs = new IPattern[1];
        FactPattern factPattern = new FactPattern();
        m.lhs[0] = factPattern;
        factPattern.addConstraint((FieldConstraint)this.makeConstraint("Applicant", "age", "Integer", "$default", "=="));
        factPattern.addConstraint((FieldConstraint)this.makeConstraint("Applicant", "name", "String", "$default", "=="));
        Assert.assertEquals((long)1L, (long)m.getInterpolationVariablesList().length);
        Assert.assertEquals((Object)"DEFAULT_TYPE", (Object)m.getInterpolationVariablesList()[0].getDataType());
    }

    @Test
    public void sameVariableFroTwoDifferentOperatorsSameType() throws Exception {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        m.lhs = new IPattern[1];
        FactPattern factPattern = new FactPattern();
        m.lhs[0] = factPattern;
        factPattern.addConstraint((FieldConstraint)this.makeConstraint("Applicant", "age", "Integer", "$default", "=="));
        factPattern.addConstraint((FieldConstraint)this.makeConstraint("Applicant", "name", "Integer", "$default", "!="));
        Assert.assertEquals((long)1L, (long)m.getInterpolationVariablesList().length);
        Assert.assertEquals((Object)"DEFAULT_TYPE", (Object)m.getInterpolationVariablesList()[0].getDataType());
    }

    @Test
    public void sameVariableFroTwoDifferentOperatorsDifferentType() throws Exception {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        m.lhs = new IPattern[1];
        FactPattern factPattern = new FactPattern();
        m.lhs[0] = factPattern;
        factPattern.addConstraint((FieldConstraint)this.makeConstraint("Applicant", "age", "Integer", "$default", "=="));
        factPattern.addConstraint((FieldConstraint)this.makeConstraint("Applicant", "name", "String", "$default", "!="));
        Assert.assertEquals((long)1L, (long)m.getInterpolationVariablesList().length);
        Assert.assertEquals((Object)"DEFAULT_TYPE", (Object)m.getInterpolationVariablesList()[0].getDataType());
    }

    @Test
    public void separateVariableNames() throws Exception {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        m.lhs = new IPattern[1];
        FactPattern factPattern = new FactPattern();
        m.lhs[0] = factPattern;
        factPattern.addConstraint((FieldConstraint)this.makeConstraint("Applicant", "age", "Integer", "$default", "=="));
        factPattern.addConstraint((FieldConstraint)this.makeConstraint("Applicant", "name", "String", "$other", "=="));
        Assert.assertEquals((long)2L, (long)m.getInterpolationVariablesList().length);
        Assert.assertEquals((Object)"Integer", (Object)m.getInterpolationVariablesList()[0].getDataType());
        Assert.assertEquals((Object)"String", (Object)m.getInterpolationVariablesList()[1].getDataType());
    }

    private SingleFieldConstraint makeConstraint(String factType, String fieldName, String fieldType, String variableName, String operator) {
        SingleFieldConstraint constraint = new SingleFieldConstraint(factType, fieldName, fieldType, null);
        constraint.setOperator(operator);
        constraint.setConstraintValueType(7);
        constraint.setValue(variableName);
        return constraint;
    }
}

