/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend.executors;

import java.util.HashMap;
import org.drools.workbench.models.testscenarios.backend.Cheesery;
import org.drools.workbench.models.testscenarios.backend.executors.MethodExecutor;
import org.drools.workbench.models.testscenarios.shared.CallFieldValue;
import org.drools.workbench.models.testscenarios.shared.CallMethod;
import org.junit.Assert;
import org.junit.Test;

public class MethodExecutorTest {
    @Test
    public void testCallMethodNoArgumentOnFact() throws Exception {
        HashMap<String, Cheesery> populatedData = new HashMap<String, Cheesery>();
        MethodExecutor methodExecutor = new MethodExecutor(populatedData);
        Cheesery listChesse = new Cheesery();
        listChesse.setTotalAmount(1000);
        populatedData.put("cheese", listChesse);
        CallMethod mCall = new CallMethod();
        mCall.setVariable("cheese");
        mCall.setMethodName("setTotalAmountToZero");
        methodExecutor.executeMethod(mCall);
        Assert.assertTrue((listChesse.getTotalAmount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCallMethodOnStandardArgumentOnFact() throws Exception {
        HashMap<String, Cheesery> populatedData = new HashMap<String, Cheesery>();
        MethodExecutor methodExecutor = new MethodExecutor(populatedData);
        Cheesery listChesse = new Cheesery();
        listChesse.setTotalAmount(1000);
        populatedData.put("cheese", listChesse);
        CallMethod mCall = new CallMethod();
        mCall.setVariable("cheese");
        mCall.setMethodName("setTotalAmount");
        CallFieldValue field = new CallFieldValue();
        field.value = "1005";
        mCall.addFieldValue(field);
        methodExecutor.executeMethod(mCall);
        Assert.assertTrue((listChesse.getTotalAmount() == 1005 ? 1 : 0) != 0);
    }

    @Test
    public void testCallMethodOnClassArgumentOnFact() throws Exception {
        HashMap<String, Object> populatedData = new HashMap<String, Object>();
        MethodExecutor methodExecutor = new MethodExecutor(populatedData);
        Cheesery listChesse = new Cheesery();
        listChesse.setTotalAmount(1000);
        populatedData.put("cheese", listChesse);
        Cheesery.Maturity m = Cheesery.Maturity.OLD;
        populatedData.put("m", (Object)m);
        CallMethod mCall = new CallMethod();
        mCall.setVariable("cheese");
        mCall.setMethodName("setMaturity");
        CallFieldValue field = new CallFieldValue();
        field.value = "=m";
        mCall.addFieldValue(field);
        methodExecutor.executeMethod(mCall);
        Assert.assertTrue((boolean)listChesse.getMaturity().equals((Object)m));
        Assert.assertTrue((listChesse.getMaturity() == m ? 1 : 0) != 0);
    }

    @Test
    public void testCallMethodOnClassArgumentAndOnArgumentStandardOnFact() throws Exception {
        HashMap<String, Object> populatedData = new HashMap<String, Object>();
        MethodExecutor methodExecutor = new MethodExecutor(populatedData);
        Cheesery listCheese = new Cheesery();
        listCheese.setTotalAmount(1000);
        populatedData.put("cheese", listCheese);
        Cheesery.Maturity m = Cheesery.Maturity.YOUNG;
        populatedData.put("m", (Object)m);
        CallMethod mCall = new CallMethod();
        mCall.setVariable("cheese");
        mCall.setMethodName("setMaturityAndStatus");
        CallFieldValue field = new CallFieldValue();
        field.value = "=m";
        mCall.addFieldValue(field);
        CallFieldValue field2 = new CallFieldValue();
        field2.value = "1";
        mCall.addFieldValue(field2);
        methodExecutor.executeMethod(mCall);
        Assert.assertEquals((Object)((Object)m), (Object)((Object)listCheese.getMaturity()));
        Assert.assertEquals((long)1L, (long)listCheese.getStatus());
    }
}

