/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend.verifiers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.drools.core.base.TypeResolver;
import org.drools.workbench.models.testscenarios.backend.Cheese;
import org.drools.workbench.models.testscenarios.backend.verifiers.FactVerifier;
import org.drools.workbench.models.testscenarios.shared.VerifyFact;
import org.drools.workbench.models.testscenarios.shared.VerifyField;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.mockito.Mockito;

public class FactVerifierTest {
    private KieSession ksession;

    @Before
    public void setUp() throws Exception {
        this.ksession = (KieSession)Mockito.mock(KieSession.class);
    }

    @Test
    public void testVerifyAnonymousFacts() throws Exception {
        TypeResolver typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        FactVerifier factVerifier = new FactVerifier(new HashMap(), typeResolver, classLoader, this.ksession, new HashMap());
        Cheese c = new Cheese();
        c.setPrice(42);
        c.setType("stilton");
        Set<Cheese> o = Collections.singleton(c);
        Mockito.when((Object)this.ksession.getObjects()).thenReturn(o);
        VerifyFact vf = new VerifyFact("Cheese", new ArrayList(), true);
        vf.getFieldValues().add(new VerifyField("price", "42", "=="));
        vf.getFieldValues().add(new VerifyField("type", "stilton", "=="));
        factVerifier.verify(vf);
        Assert.assertTrue((boolean)vf.wasSuccessful());
        vf = new VerifyFact("Person", new ArrayList(), true);
        vf.getFieldValues().add(new VerifyField("age", "42", "=="));
        factVerifier.verify(vf);
        Assert.assertFalse((boolean)vf.wasSuccessful());
        vf = new VerifyFact("Cheese", new ArrayList(), true);
        vf.getFieldValues().add(new VerifyField("price", "43", "=="));
        vf.getFieldValues().add(new VerifyField("type", "stilton", "=="));
        factVerifier.verify(vf);
        Assert.assertFalse((boolean)vf.wasSuccessful());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)((VerifyField)vf.getFieldValues().get(0)).getSuccessResult());
        vf = new VerifyFact("Cell", new ArrayList(), true);
        vf.getFieldValues().add(new VerifyField("value", "43", "=="));
        factVerifier.verify(vf);
        Assert.assertFalse((boolean)vf.wasSuccessful());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)((VerifyField)vf.getFieldValues().get(0)).getSuccessResult());
    }

    @Test
    public void testVerifyFactsWithOperator() throws Exception {
        TypeResolver typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Cheese f1 = new Cheese("cheddar", 42);
        HashMap<String, Cheese> populatedData = new HashMap<String, Cheese>();
        populatedData.put("f1", f1);
        Set<Cheese> o = Collections.singleton(f1);
        Mockito.when((Object)this.ksession.getObjects()).thenReturn(o);
        FactVerifier factVerifier = new FactVerifier(populatedData, typeResolver, classLoader, this.ksession, new HashMap());
        VerifyFact vf = new VerifyFact();
        vf.setName("f1");
        vf.getFieldValues().add(new VerifyField("type", "cheddar", "=="));
        vf.getFieldValues().add(new VerifyField("price", "4777", "!="));
        factVerifier.verify(vf);
        for (int i = 0; i < vf.getFieldValues().size(); ++i) {
            Assert.assertTrue((boolean)((VerifyField)vf.getFieldValues().get(i)).getSuccessResult());
        }
        vf = new VerifyFact();
        vf.setName("f1");
        vf.getFieldValues().add(new VerifyField("type", "cheddar", "!="));
        factVerifier.verify(vf);
        Assert.assertFalse((boolean)((VerifyField)vf.getFieldValues().get(0)).getSuccessResult());
    }

    @Test
    public void testVerifyFactsWithExpression() throws Exception {
        TypeResolver typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Cheese f1 = new Cheese("cheddar", 42);
        f1.setPrice(42);
        HashMap<String, Cheese> populatedData = new HashMap<String, Cheese>();
        populatedData.put("f1", f1);
        Set<Cheese> o = Collections.singleton(f1);
        Mockito.when((Object)this.ksession.getObjects()).thenReturn(o);
        FactVerifier factVerifier = new FactVerifier(populatedData, typeResolver, classLoader, this.ksession, new HashMap());
        VerifyFact vf = new VerifyFact();
        vf.setName("f1");
        vf.getFieldValues().add(new VerifyField("price", "= 40 + 2", "=="));
        factVerifier.verify(vf);
        Assert.assertTrue((boolean)((VerifyField)vf.getFieldValues().get(0)).getSuccessResult());
    }

    @Test
    public void testVerifyFactExplanation() throws Exception {
        Cheese f1 = new Cheese();
        f1.setType(null);
        TypeResolver typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HashMap<String, Cheese> populatedData = new HashMap<String, Cheese>();
        populatedData.put("f1", f1);
        Set<Cheese> o = Collections.singleton(f1);
        Mockito.when((Object)this.ksession.getObjects()).thenReturn(o);
        FactVerifier factVerifier = new FactVerifier(populatedData, typeResolver, classLoader, this.ksession, new HashMap());
        VerifyFact vf = new VerifyFact();
        vf.setName("f1");
        vf.getFieldValues().add(new VerifyField("type", "boo", "!="));
        factVerifier.verify(vf);
        VerifyField vfl = (VerifyField)vf.getFieldValues().get(0);
        Assert.assertEquals((Object)"[f1] field [type] was not [boo].", (Object)vfl.getExplanation());
    }

    @Test
    public void testVerifyFieldAndActualIsNull() throws Exception {
        Cheese f1 = new Cheese();
        f1.setType(null);
        TypeResolver typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HashMap<String, Cheese> populatedData = new HashMap<String, Cheese>();
        populatedData.put("f1", f1);
        Set<Cheese> o = Collections.singleton(f1);
        Mockito.when((Object)this.ksession.getObjects()).thenReturn(o);
        FactVerifier factVerifier = new FactVerifier(populatedData, typeResolver, classLoader, this.ksession, new HashMap());
        VerifyFact vf = new VerifyFact();
        vf.setName("f1");
        vf.getFieldValues().add(new VerifyField("type", "boo", "=="));
        factVerifier.verify(vf);
        VerifyField vfl = (VerifyField)vf.getFieldValues().get(0);
        Assert.assertEquals((Object)"[f1] field [type] was [] expected [boo].", (Object)vfl.getExplanation());
        Assert.assertEquals((Object)"boo", (Object)vfl.getExpected());
        Assert.assertEquals((Object)"", (Object)vfl.getActualResult());
    }
}

