/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend;

import java.util.ArrayList;
import java.util.HashSet;
import org.drools.workbench.models.testscenarios.backend.Cheese;
import org.drools.workbench.models.testscenarios.backend.RuleUnit;
import org.drools.workbench.models.testscenarios.backend.TestingEventListener;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.KieSession;

public class TestingEventListenerTest
extends RuleUnit {
    @Test
    public void testInclusive() throws Exception {
        HashSet<String> set = new HashSet<String>();
        set.add("rule1");
        set.add("rule2");
        KieSession session = this.getKieSession("test_rules.drl");
        TestingEventListener ls = new TestingEventListener();
        session.addEventListener((AgendaEventListener)ls);
        session.insert((Object)new Cheese());
        session.fireAllRules(ls.getAgendaFilter(set, true));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule1")));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule2")));
        Assert.assertFalse((boolean)ls.firingCounts.containsKey("rule3"));
        Assert.assertFalse((boolean)ls.firingCounts.containsKey("rule4"));
        session.insert((Object)new Cheese());
        session.fireAllRules(ls.getAgendaFilter(set, true));
        Assert.assertEquals((Object)new Integer(2), (Object)((Integer)ls.firingCounts.get("rule1")));
        Assert.assertEquals((Object)new Integer(2), (Object)((Integer)ls.firingCounts.get("rule2")));
        Assert.assertFalse((boolean)ls.firingCounts.containsKey("rule3"));
        Assert.assertEquals((long)4L, (long)ls.totalFires);
    }

    @Test
    public void testExclusive() throws Exception {
        HashSet<String> set = new HashSet<String>();
        set.add("rule3");
        KieSession session = this.getKieSession("test_rules.drl");
        TestingEventListener ls = new TestingEventListener();
        session.addEventListener((AgendaEventListener)ls);
        session.insert((Object)new Cheese());
        session.fireAllRules(ls.getAgendaFilter(set, false));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule2")));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule1")));
        Assert.assertFalse((boolean)ls.firingCounts.containsKey("rule3"));
        Assert.assertFalse((boolean)ls.firingCounts.containsKey("rule4"));
    }

    @Test
    public void testNoFilter() throws Exception {
        HashSet set = new HashSet();
        KieSession session = this.getKieSession("test_rules.drl");
        TestingEventListener ls = new TestingEventListener();
        session.addEventListener((AgendaEventListener)ls);
        session.insert((Object)new Cheese());
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.fireAllRules(ls.getAgendaFilter(set, false));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule1")));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule2")));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule3")));
        String[] summary = ls.getRulesFiredSummary();
        Assert.assertEquals((long)3L, (long)summary.length);
        Assert.assertNotNull((Object)summary[0]);
        Assert.assertFalse((boolean)summary[1].equals(""));
        Assert.assertEquals((long)1L, (long)list.size());
    }
}

