/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend.verifiers;

import java.util.HashMap;
import org.drools.workbench.models.testscenarios.backend.verifiers.RuleFiredVerifier;
import org.drools.workbench.models.testscenarios.shared.VerifyRuleFired;
import org.junit.Assert;
import org.junit.Test;

public class RuleFiredVerifierTest {
    @Test
    public void testCountVerification() throws Exception {
        HashMap<String, Integer> firingCounts = new HashMap<String, Integer>();
        firingCounts.put("foo", 2);
        firingCounts.put("bar", 1);
        RuleFiredVerifier ruleFiredVerifier = new RuleFiredVerifier();
        ruleFiredVerifier.setFireCounter(firingCounts);
        VerifyRuleFired v = new VerifyRuleFired();
        v.setRuleName("foo");
        v.setExpectedFire(Boolean.valueOf(true));
        ruleFiredVerifier.verifyFiringCounts(v);
        Assert.assertTrue((boolean)v.getSuccessResult());
        Assert.assertEquals((long)2L, (long)v.getActualResult().intValue());
        v = new VerifyRuleFired();
        v.setRuleName("foo");
        v.setExpectedFire(Boolean.valueOf(false));
        ruleFiredVerifier.verifyFiringCounts(v);
        Assert.assertFalse((boolean)v.getSuccessResult());
        Assert.assertEquals((long)2L, (long)v.getActualResult().intValue());
        Assert.assertNotNull((Object)v.getExplanation());
        v = new VerifyRuleFired();
        v.setRuleName("foo");
        v.setExpectedCount(Integer.valueOf(2));
        ruleFiredVerifier.verifyFiringCounts(v);
        Assert.assertTrue((boolean)v.getSuccessResult());
        Assert.assertEquals((long)2L, (long)v.getActualResult().intValue());
    }

    @Test
    public void testRuleFiredWithEnum() throws Exception {
        HashMap<String, Integer> firingCounts = new HashMap<String, Integer>();
        firingCounts.put("foo", 2);
        firingCounts.put("bar", 1);
        RuleFiredVerifier ruleFiredVerifier = new RuleFiredVerifier();
        ruleFiredVerifier.setFireCounter(firingCounts);
        VerifyRuleFired v = new VerifyRuleFired();
        v.setRuleName("foo");
        v.setExpectedFire(Boolean.valueOf(true));
        ruleFiredVerifier.verifyFiringCounts(v);
        Assert.assertTrue((boolean)v.getSuccessResult());
        Assert.assertEquals((long)2L, (long)v.getActualResult().intValue());
    }

    @Test
    public void testVerifyRuleFired() throws Exception {
        RuleFiredVerifier ruleFiredVerifier = new RuleFiredVerifier();
        VerifyRuleFired vr = new VerifyRuleFired("qqq", Integer.valueOf(42), null);
        HashMap<String, Integer> f = new HashMap<String, Integer>();
        f.put("qqq", 42);
        f.put("qaz", 1);
        ruleFiredVerifier.setFireCounter(f);
        ruleFiredVerifier.verifyFiringCounts(vr);
        Assert.assertTrue((boolean)vr.wasSuccessful());
        Assert.assertEquals((long)42L, (long)vr.getActualResult().intValue());
        vr = new VerifyRuleFired("qqq", Integer.valueOf(41), null);
        ruleFiredVerifier.setFireCounter(f);
        ruleFiredVerifier.verifyFiringCounts(vr);
        Assert.assertFalse((boolean)vr.wasSuccessful());
        Assert.assertEquals((long)42L, (long)vr.getActualResult().intValue());
        vr = new VerifyRuleFired("qaz", Integer.valueOf(1), null);
        ruleFiredVerifier.setFireCounter(f);
        ruleFiredVerifier.verifyFiringCounts(vr);
        Assert.assertTrue((boolean)vr.wasSuccessful());
        Assert.assertEquals((long)1L, (long)vr.getActualResult().intValue());
        vr = new VerifyRuleFired("XXX", null, Boolean.valueOf(false));
        ruleFiredVerifier.setFireCounter(f);
        ruleFiredVerifier.verifyFiringCounts(vr);
        Assert.assertTrue((boolean)vr.wasSuccessful());
        Assert.assertEquals((long)0L, (long)vr.getActualResult().intValue());
        vr = new VerifyRuleFired("qqq", null, Boolean.valueOf(true));
        ruleFiredVerifier.setFireCounter(f);
        ruleFiredVerifier.verifyFiringCounts(vr);
        Assert.assertTrue((boolean)vr.wasSuccessful());
        Assert.assertEquals((long)42L, (long)vr.getActualResult().intValue());
        vr = new VerifyRuleFired("qqq", null, Boolean.valueOf(false));
        ruleFiredVerifier.setFireCounter(f);
        ruleFiredVerifier.verifyFiringCounts(vr);
        Assert.assertFalse((boolean)vr.wasSuccessful());
        Assert.assertEquals((long)42L, (long)vr.getActualResult().intValue());
    }
}

