/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.testscenarios.backend.Cheese;

public class Cheesery
implements Serializable {
    private static final long serialVersionUID = 510L;
    public static final int MAKING_CHEESE = 0;
    public static final int SELLING_CHEESE = 1;
    private List<Cheese> cheeses = new ArrayList<Cheese>();
    private int status;
    private int totalAmount;
    private Maturity maturity;

    public List<Cheese> getCheeses() {
        return this.cheeses;
    }

    public void setCheeses(List<Cheese> l) {
        this.cheeses = l;
    }

    public void addCheese(Cheese cheese) {
        this.cheeses.add(cheese);
        this.totalAmount += cheese.getPrice();
    }

    public void removeCheese(Cheese cheese) {
        this.cheeses.remove(cheese);
        this.recalculateTotalAmount();
    }

    private void recalculateTotalAmount() {
        this.totalAmount = 0;
        for (Cheese cheese : this.cheeses) {
            this.totalAmount += cheese.getPrice();
        }
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public int getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(int totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setTotalAmountToZero() {
        this.totalAmount = 0;
    }

    public Maturity getMaturity() {
        return this.maturity;
    }

    public void setMaturity(Maturity m) {
        this.maturity = m;
    }

    public void setMaturityAndStatus(Maturity m, int status) {
        this.maturity = m;
        this.status = status;
    }

    public static enum Maturity {
        YOUNG,
        OLD;

    }
}

