/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend.util;

import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.drools.core.util.DateUtils;
import org.drools.workbench.models.testscenarios.backend.util.DateObjectFactory;
import org.junit.Assert;
import org.junit.Test;

public class DateObjectFactoryTest {
    @Test
    public void date() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object timeObject = DateObjectFactory.createDateObject(Date.class, (String)"12-Sep-2011");
        Assert.assertTrue((boolean)(timeObject instanceof Date));
        Assert.assertEquals((Object)"12-Sep-2011", (Object)DateUtils.format((Date)((Date)timeObject)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void dateInvalidValue() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        DateObjectFactory.createDateObject(Date.class, (String)"12345");
    }

    @Test(expected=NoSuchMethodException.class)
    public void dateInvalidClass() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        DateObjectFactory.createDateObject(String.class, (String)"12-Sep-2011");
    }

    @Test
    public void localDate() {
        LocalDate timeObject = DateObjectFactory.createLocalDateObject((String)"12-Sep-2011");
        Assert.assertTrue((boolean)(timeObject instanceof LocalDate));
        LocalDate localDate = timeObject;
        Assert.assertEquals((long)2011L, (long)localDate.getYear());
        Assert.assertEquals((Object)Month.SEPTEMBER, (Object)localDate.getMonth());
        Assert.assertEquals((long)12L, (long)localDate.getDayOfMonth());
    }

    @Test(expected=DateTimeParseException.class)
    public void localDateInvalidValue() {
        DateObjectFactory.createLocalDateObject((String)"1234");
    }
}

