/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend.verifiers;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.drools.core.addon.TypeResolver;
import org.drools.workbench.models.testscenarios.backend.SqlDateWrapper;
import org.drools.workbench.models.testscenarios.backend.StringCollection;
import org.drools.workbench.models.testscenarios.backend.verifiers.FactFieldValueVerifier;
import org.drools.workbench.models.testscenarios.shared.VerifyField;
import org.junit.Test;
import org.mockito.Mockito;

public class FactFieldValueVerifierTest
extends TestCase {
    @Test
    public void testSQLDate() throws Exception {
        SqlDateWrapper sqlDateWrapper = new SqlDateWrapper();
        sqlDateWrapper.setSqlDate(new Date(112, 11, 12));
        HashMap<String, SqlDateWrapper> populatedData = new HashMap<String, SqlDateWrapper>();
        populatedData.put("sqlDateWrapper", sqlDateWrapper);
        TypeResolver typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        FactFieldValueVerifier verifier = new FactFieldValueVerifier(populatedData, "sqlDateWrapper", (Object)sqlDateWrapper, typeResolver);
        ArrayList<VerifyField> fieldValues = new ArrayList<VerifyField>();
        VerifyField verifyField = new VerifyField("sqlDate", "12-DEC-2012", "==");
        fieldValues.add(verifyField);
        verifier.checkFields(fieldValues);
        FactFieldValueVerifierTest.assertTrue((boolean)verifyField.getSuccessResult());
    }

    @Test
    public void testExpectedList() throws Exception {
        StringCollection collection = new StringCollection();
        collection.getList().add("Edam");
        collection.getList().add("Cheddar");
        HashMap<String, StringCollection> populatedData = new HashMap<String, StringCollection>();
        populatedData.put("collection", collection);
        TypeResolver typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        FactFieldValueVerifier verifier = new FactFieldValueVerifier(populatedData, "collection", (Object)collection, typeResolver);
        ArrayList<VerifyField> fieldValues = new ArrayList<VerifyField>();
        VerifyField verifyField = new VerifyField("list", "=[\"Edam\", \"Cheddar\"]", "==");
        fieldValues.add(verifyField);
        verifier.checkFields(fieldValues);
        FactFieldValueVerifierTest.assertTrue((boolean)verifyField.getSuccessResult());
    }

    @Test
    public void testExpectedListComplexValues() throws Exception {
        StringCollection collection = new StringCollection();
        collection.getList().add("Edam, Mature");
        collection.getList().add("(Cheddar, Premature)");
        HashMap<String, StringCollection> populatedData = new HashMap<String, StringCollection>();
        populatedData.put("collection", collection);
        TypeResolver typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        FactFieldValueVerifier verifier = new FactFieldValueVerifier(populatedData, "collection", (Object)collection, typeResolver);
        ArrayList<VerifyField> fieldValues = new ArrayList<VerifyField>();
        VerifyField verifyField = new VerifyField("list", "=[\"Edam, Mature\", \"(Cheddar, Premature)\"]", "==");
        fieldValues.add(verifyField);
        verifier.checkFields(fieldValues);
        FactFieldValueVerifierTest.assertTrue((boolean)verifyField.getSuccessResult());
    }

    @Test
    public void testExpectedListIsEmpty() throws Exception {
        StringCollection collection = new StringCollection();
        HashMap<String, StringCollection> populatedData = new HashMap<String, StringCollection>();
        populatedData.put("collection", collection);
        TypeResolver typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        FactFieldValueVerifier verifier = new FactFieldValueVerifier(populatedData, "collection", (Object)collection, typeResolver);
        ArrayList<VerifyField> fieldValues = new ArrayList<VerifyField>();
        VerifyField verifyField = new VerifyField("list", "=[]", "==");
        fieldValues.add(verifyField);
        verifier.checkFields(fieldValues);
        FactFieldValueVerifierTest.assertTrue((boolean)verifyField.getSuccessResult());
    }

    @Test
    public void testExpectedListHasDifferentContent() throws Exception {
        StringCollection collection = new StringCollection();
        collection.getList().add("cheddar");
        HashMap<String, StringCollection> populatedData = new HashMap<String, StringCollection>();
        populatedData.put("collection", collection);
        TypeResolver typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        FactFieldValueVerifier verifier = new FactFieldValueVerifier(populatedData, "collection", (Object)collection, typeResolver);
        ArrayList<VerifyField> fieldValues = new ArrayList<VerifyField>();
        VerifyField verifyField = new VerifyField("list", "=[\"CHEDDAR\"]", "!=");
        fieldValues.add(verifyField);
        verifier.checkFields(fieldValues);
        FactFieldValueVerifierTest.assertTrue((boolean)verifyField.getSuccessResult());
    }
}

