/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend.populators;

import org.drools.core.base.TypeResolver;
import org.drools.workbench.models.testscenarios.backend.Cheese;
import org.drools.workbench.models.testscenarios.backend.populators.FieldPopulator;
import org.drools.workbench.models.testscenarios.backend.populators.FieldPopulatorFactory;
import org.drools.workbench.models.testscenarios.shared.Fact;
import org.drools.workbench.models.testscenarios.shared.FactAssignmentField;
import org.drools.workbench.models.testscenarios.shared.Field;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class FieldPopulatorFactoryTest {
    private FieldPopulatorFactory fieldPopulatorFactory;
    private TypeResolver typeResolver;

    @Before
    public void setUp() throws Exception {
        Object factObject = Mockito.mock(Object.class);
        this.typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        this.fieldPopulatorFactory = new FieldPopulatorFactory(factObject, this.typeResolver);
    }

    @Test
    public void testFactAssignmentField() throws Exception {
        FactAssignmentField field = new FactAssignmentField();
        field.setFact(new Fact());
        Mockito.when((Object)this.typeResolver.resolveType((String)Matchers.any())).thenReturn(Cheese.class);
        FieldPopulator fieldPopulator = this.fieldPopulatorFactory.getFieldPopulator((Field)field);
        Assert.assertNotNull((Object)fieldPopulator);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnknownFieldType() throws Exception {
        this.fieldPopulatorFactory.getFieldPopulator((Field)new WhoAmIField());
    }

    class WhoAmIField
    implements Field {
        WhoAmIField() {
        }

        public String getName() {
            return "?";
        }
    }
}

