/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend.populators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.drools.core.base.ClassTypeResolver;
import org.drools.core.base.TypeResolver;
import org.drools.workbench.models.testscenarios.backend.populators.NewFactPopulator;
import org.drools.workbench.models.testscenarios.shared.FactData;
import org.drools.workbench.models.testscenarios.shared.FieldData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.mockito.Mockito;

public class NewFactPopulatorTest {
    private TypeResolver typeResolver;
    private HashMap<String, Object> populatedData;
    private KieSession workingMemory;

    @Before
    public void setUp() throws Exception {
        this.typeResolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        this.populatedData = new HashMap();
        this.workingMemory = (KieSession)Mockito.mock(KieSession.class);
    }

    @Test
    public void testDummyRunNoRules() throws Exception {
        this.typeResolver.addImport("org.drools.workbench.models.testscenarios.backend.Cheese");
        ArrayList<FieldData> fieldData = new ArrayList<FieldData>();
        fieldData.add(new FieldData("type", "cheddar"));
        fieldData.add(new FieldData("price", "42"));
        FactData fact = new FactData("Cheese", "c1", fieldData, false);
        NewFactPopulator newFactPopulator = new NewFactPopulator(this.populatedData, this.typeResolver, fact);
        newFactPopulator.populate(this.workingMemory, new HashMap());
        Assert.assertTrue((boolean)this.populatedData.containsKey("c1"));
        Assert.assertNotNull((Object)this.populatedData.get("c1"));
        ((KieSession)Mockito.verify((Object)this.workingMemory)).insert(this.populatedData.get("c1"));
    }
}

