/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend;

import java.util.Arrays;
import org.drools.workbench.models.testscenarios.backend.RuleUnit;
import org.drools.workbench.models.testscenarios.backend.ScenarioPMMLRunner;
import org.drools.workbench.models.testscenarios.shared.ExecutionTrace;
import org.drools.workbench.models.testscenarios.shared.FactData;
import org.drools.workbench.models.testscenarios.shared.FieldData;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.models.testscenarios.shared.VerifyScorecardScore;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.soup.project.datamodel.imports.Import;

public class ScenarioPMMLRunnerTest
extends RuleUnit {
    @Test
    public void testScoreCardPasses() throws Exception {
        this.runScorecardTest("abc", true);
    }

    @Test
    public void testScoreCardFails() throws Exception {
        this.runScorecardTest("wrongValue", false);
    }

    private void runScorecardTest(String nameValue, boolean expected) throws Exception {
        KieSession kieSession = this.getKieSession("test_scard.scgd");
        ScenarioPMMLRunner runner = new ScenarioPMMLRunner(kieSession.getKieBase());
        Scenario scenario = new Scenario();
        scenario.getImports().addImport(new Import("org.drools.workbench.models.testscenarios.backend.Person"));
        scenario.setPackageName("org.drools.workbench.models.testscenarios.backend");
        scenario.setModelName("Scard");
        scenario.getFixtures().add(new FactData("Person", "f2", Arrays.asList(new FieldData("name", nameValue)), false));
        scenario.getFixtures().add(new ExecutionTrace());
        VerifyScorecardScore verifyScorecardScore = new VerifyScorecardScore(Double.valueOf(25.0));
        scenario.getFixtures().add(verifyScorecardScore);
        runner.run(scenario);
        Assert.assertEquals((Object)expected, (Object)verifyScorecardScore.wasSuccessful());
    }
}

