/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend;

import java.util.HashMap;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.workbench.models.testscenarios.backend.ScenarioRunner4JUnit;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ScenarioRunner4JUnitTest {
    private StatefulKnowledgeSessionImpl ksession;

    @Before
    public void setUp() throws Exception {
        this.ksession = (StatefulKnowledgeSessionImpl)Mockito.mock(StatefulKnowledgeSessionImpl.class);
        KnowledgeBaseImpl knowledgeBase = (KnowledgeBaseImpl)Mockito.mock(KnowledgeBaseImpl.class);
        Mockito.when((Object)this.ksession.getKieBase()).thenReturn((Object)knowledgeBase);
        ProjectClassLoader classLoader = ProjectClassLoader.createProjectClassLoader();
        Mockito.when((Object)knowledgeBase.getRootClassLoader()).thenReturn((Object)classLoader);
    }

    @Test
    public void testBasic() throws Exception {
        HashMap<String, StatefulKnowledgeSessionImpl> ksessions = new HashMap<String, StatefulKnowledgeSessionImpl>();
        ksessions.put("someId", this.ksession);
        Scenario scenario = new Scenario();
        scenario.getKSessions().add("someId");
        ScenarioRunner4JUnit runner4JUnit = new ScenarioRunner4JUnit(scenario, ksessions);
        RunNotifier notifier = new RunNotifier();
        RunListener runListener = (RunListener)Mockito.spy((Object)new RunListener());
        notifier.addListener(runListener);
        runner4JUnit.run(notifier);
        ((RunListener)Mockito.verify((Object)runListener, (VerificationMode)Mockito.never())).testFailure((Failure)Matchers.any(Failure.class));
        ((RunListener)Mockito.verify((Object)runListener)).testFinished((Description)Matchers.any(Description.class));
        ((StatefulKnowledgeSessionImpl)Mockito.verify((Object)this.ksession)).reset();
    }

    @Test
    public void testIDNotSet() throws Exception {
        HashMap<Object, StatefulKnowledgeSessionImpl> ksessions = new HashMap<Object, StatefulKnowledgeSessionImpl>();
        ksessions.put(null, this.ksession);
        ScenarioRunner4JUnit runner4JUnit = new ScenarioRunner4JUnit(new Scenario(), ksessions);
        RunNotifier notifier = new RunNotifier();
        RunListener runListener = (RunListener)Mockito.spy((Object)new RunListener());
        notifier.addListener(runListener);
        runner4JUnit.run(notifier);
        ((RunListener)Mockito.verify((Object)runListener, (VerificationMode)Mockito.never())).testFailure((Failure)Matchers.any(Failure.class));
        ((RunListener)Mockito.verify((Object)runListener)).testFinished((Description)Matchers.any(Description.class));
        ((StatefulKnowledgeSessionImpl)Mockito.verify((Object)this.ksession)).reset();
    }

    @Test
    public void testNoKieSession() throws Exception {
        ScenarioRunner4JUnit runner4JUnit = new ScenarioRunner4JUnit(new Scenario(), new HashMap());
        RunNotifier notifier = new RunNotifier();
        RunListener runListener = (RunListener)Mockito.spy((Object)new RunListener());
        notifier.addListener(runListener);
        runner4JUnit.run(notifier);
        ((RunListener)Mockito.verify((Object)runListener)).testFailure((Failure)Matchers.any(Failure.class));
    }

    @Test
    public void testNoKieWithGivenIDSession() throws Exception {
        HashMap<String, StatefulKnowledgeSessionImpl> ksessions = new HashMap<String, StatefulKnowledgeSessionImpl>();
        ksessions.put("someID", this.ksession);
        Scenario scenario = new Scenario();
        scenario.getKSessions().add("someOtherID");
        ScenarioRunner4JUnit runner4JUnit = new ScenarioRunner4JUnit(scenario, ksessions);
        RunNotifier notifier = new RunNotifier();
        RunListener runListener = (RunListener)Mockito.spy((Object)new RunListener());
        notifier.addListener(runListener);
        runner4JUnit.run(notifier);
        ((RunListener)Mockito.verify((Object)runListener)).testFailure((Failure)Matchers.any(Failure.class));
    }
}

